/*
 * Decompiled with CFR 0.152.
 */
package rmap.pkg0;

import cadenas.FechaHora;
import java.io.Serializable;
import java.util.GregorianCalendar;
import rmap.pkg0.Celda;

public class Skymap
implements Serializable {
    static final long serialVersionUID = 100001L;
    public float quality_factor = 1.0f;
    public boolean usado = false;
    public GregorianCalendar hora = new GregorianCalendar();
    public int ASRDIV = 72;
    public int DECDIV = 36;
    public double ASRREF = 0.0;
    public Celda[][] celdas = new Celda[this.ASRDIV][this.DECDIV];
    static int NUMERO_DE_OBSERVADORES = 1;
    static int CONTEO = 2;
    static int ESTIMACION = 3;
    static int ESTIMACION_RELATIVA = 4;
    static int CONTEO_RELATIVO = 5;

    public Skymap() {
        int x = 0;
        int y = 0;
        this.usado = false;
        this.hora = new GregorianCalendar();
        for (x = 0; x < this.ASRDIV; ++x) {
            for (y = 0; y < this.DECDIV; ++y) {
                this.celdas[x][y] = new Celda();
            }
        }
    }

    public void set_Skymap(Skymap sk) {
        this.usado = sk.usado;
        this.hora.setTime(sk.hora.getTime());
        this.quality_factor = sk.quality_factor;
        for (int x = 0; x < this.ASRDIV; ++x) {
            for (int y = 0; y < this.DECDIV; ++y) {
                this.celdas[x][y].set_Celda(sk.get_celda(x, y));
            }
        }
    }

    void set_hora(GregorianCalendar gc) {
        this.hora = gc;
    }

    GregorianCalendar get_hora() {
        return this.hora;
    }

    void set_celda_xy(int x, int y, Celda c) {
        this.celdas[x][y].numero_de_observadores = c.numero_de_observadores;
        this.celdas[x][y].conteo_total = c.conteo_total;
        this.celdas[x][y].estimacion = c.estimacion;
        this.celdas[x][y].estimacion_relativa = c.estimacion_relativa;
    }

    Celda get_celda(int x, int y) {
        return this.celdas[x][y];
    }

    void sumar_celda_xy(int x, int y, Celda c) throws Exception {
        long nobs = c.get_numero_de_observadores();
        long cont = c.get_conteo_total();
        float crel = c.get_conteo_relativo();
        this.celdas[x][y].suma_datos(nobs, cont, crel);
    }

    int[] get_posicion_celda(double ascension_recta, double declinacion) {
        int[] pos = new int[2];
        if (ascension_recta == 24.0) {
            ascension_recta = 0.0;
        }
        pos[0] = (int)(ascension_recta / 0.3333333333);
        if (pos[0] > this.ASRDIV - 1) {
            pos[0] = pos[0] - this.ASRDIV;
        }
        if (pos[0] < 0) {
            pos[0] = this.ASRDIV + pos[0];
        }
        pos[1] = (int)((90.0 + declinacion) / 5.0);
        if (pos[1] < 0) {
            pos[1] = 0;
        }
        return pos;
    }

    void set_square_fooprint_2(double ascension_recta, double declinacion, Celda c) throws Exception {
        int[] pos = new int[2];
        pos = this.get_posicion_celda(ascension_recta, declinacion);
        boolean outlimit = false;
        for (int x = pos[0] - 1; x < pos[0] + 2; ++x) {
            for (int y = pos[1] - 1; y < pos[1] + 2; ++y) {
                int a = x;
                int b = y;
                if (a > this.ASRDIV - 1) {
                    a -= this.ASRDIV;
                }
                if (a < 0) {
                    a = this.ASRDIV + a;
                }
                if (b > this.DECDIV - 1) {
                    b = this.DECDIV - 1 - (b - this.DECDIV);
                    outlimit = true;
                }
                if (b < 0) {
                    b = -b - 1;
                    outlimit = true;
                }
                if (outlimit) {
                    if (a < this.DECDIV - 1) {
                        a += 2 * (this.DECDIV - a);
                        outlimit = false;
                        if (a > this.ASRDIV - 1) {
                            a -= this.ASRDIV - 1;
                        }
                    } else {
                        a -= 2 * (a - this.DECDIV);
                        outlimit = false;
                        if (a < 0) {
                            a = this.ASRDIV + a;
                        }
                    }
                }
                this.sumar_celda_xy(a, b, c);
            }
        }
    }

    void set_square_fooprint_1(double ascension_recta, double declinacion, int offsetx, int offsety, Celda c) throws Exception {
        int[] pos = new int[2];
        pos = this.get_posicion_celda(ascension_recta, declinacion);
        int ox = pos[0] + offsetx;
        int oy = pos[1] + offsety;
        int x = ox;
        int y = oy;
        if (y < 0) {
            y = 0;
            if (x < this.DECDIV - 1) {
                if ((x = x + 2 * (this.DECDIV - 1 - x) + 1) > this.ASRDIV - 1) {
                    x -= this.ASRDIV;
                }
            } else if ((x = x - 2 * (x - (this.DECDIV - 1)) + 1) < 0) {
                x = this.ASRDIV - 1;
            }
        }
        if (y > this.DECDIV - 1) {
            y = this.DECDIV - 1;
            if (x < this.DECDIV - 1) {
                if ((x = x + 2 * (this.DECDIV - 1 - x) + 1) > this.ASRDIV - 1) {
                    x -= this.ASRDIV;
                }
            } else if ((x = x - 2 * (x - (this.DECDIV - 1)) + 1) < 0) {
                x = this.ASRDIV - 1;
            }
        }
        if (x < 0) {
            x = this.ASRDIV - 1;
        }
        if (x > this.ASRDIV - 1) {
            x -= this.ASRDIV;
        }
        this.sumar_celda_xy(x, y, c);
        if (++x > this.ASRDIV - 1) {
            x -= this.ASRDIV;
        }
        this.sumar_celda_xy(x, y, c);
        if (--x < 0) {
            x = this.ASRDIV - 1;
        }
        if (--x < 0) {
            x = this.ASRDIV - 1;
        }
        this.sumar_celda_xy(x, y, c);
        x = ox;
        y = oy;
        if (++y > this.DECDIV - 1) {
            y = this.DECDIV - 1;
            if (x < this.DECDIV - 1) {
                if ((x = x + 2 * (this.DECDIV - 1 - x) + 1) > this.ASRDIV - 1) {
                    x -= this.ASRDIV;
                }
            } else if ((x = x - 2 * (x - (this.DECDIV - 1)) + 1) < 0) {
                x = this.ASRDIV - 1;
            }
        }
        if (x < 0) {
            x = this.ASRDIV - 1;
        }
        if (x > this.ASRDIV - 1) {
            x -= this.ASRDIV;
        }
        this.sumar_celda_xy(x, y, c);
        if (++x > this.ASRDIV - 1) {
            x -= this.ASRDIV;
        }
        this.sumar_celda_xy(x, y, c);
        if (--x < 0) {
            x = this.ASRDIV - 1;
        }
        if (--x < 0) {
            x = this.ASRDIV - 1;
        }
        this.sumar_celda_xy(x, y, c);
        x = ox;
        y = oy;
        if (--y < 0) {
            y = 0;
            if (x < this.DECDIV - 1) {
                if ((x = x + 2 * (this.DECDIV - 1 - x) + 1) > this.ASRDIV - 1) {
                    x -= this.ASRDIV;
                }
            } else if ((x = x - 2 * (x - (this.DECDIV - 1)) + 1) < 0) {
                x = this.ASRDIV - 1;
            }
        }
        if (x < 0) {
            x = this.ASRDIV - 1;
        }
        if (x > this.ASRDIV - 1) {
            x -= this.ASRDIV;
        }
        this.sumar_celda_xy(x, y, c);
        if (++x > this.ASRDIV - 1) {
            x -= this.ASRDIV;
        }
        this.sumar_celda_xy(x, y, c);
        if (--x < 0) {
            x = this.ASRDIV - 1;
        }
        if (--x < 0) {
            x = this.ASRDIV - 1;
        }
        this.sumar_celda_xy(x, y, c);
    }

    public int unir(Skymap a, int tipo) throws Exception {
        int x = 0;
        int y = 0;
        String hora1 = "";
        String hora2 = "";
        FechaHora horax = new FechaHora();
        hora1 = horax.presenta_AMD(this.hora);
        if (hora1.equals(hora2 = horax.presenta_AMD(a.hora)) & tipo == 1 || this.hora.get(2) == a.hora.get(2) & tipo == 2 || tipo == 3) {
            for (x = 0; x < this.ASRDIV; ++x) {
                for (y = 0; y < this.DECDIV; ++y) {
                    this.celdas[x][y].suma_datos(a.celdas[x][y].get_numero_de_observadores(), a.celdas[x][y].get_conteo_total(), a.celdas[x][y].get_conteo_relativo());
                }
            }
            return 0;
        }
        return 1;
    }
}

