/*
 * Decompiled with CFR 0.152.
 */
package rmap.pkg0;

import astronomia.Reloj_Sideral;
import cadenas.FechaHora;
import ficheros.FicheroTexto;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import report.MessageBox;
import rmap.pkg0.Celda;
import rmap.pkg0.FicheroRMOB;
import rmap.pkg0.Medidas_de_Dispersion;
import rmap.pkg0.RaMAP;

public class Procesa_Ficheros_RMOB
implements Runnable {
    private boolean apply_antenna_settings = false;
    private String rutaynombre_skm = "";
    private String rutaynombre_txt = "";
    private MessageBox mb = new MessageBox();
    public String month_box = "";
    public String year_box = "";
    public int progreso = 0;
    private boolean form_visible = true;
    public boolean end_process = false;
    private FicheroTexto ft = new FicheroTexto();
    private FicheroTexto fs = new FicheroTexto();
    private FicheroRMOB frmob = new FicheroRMOB();
    private FicheroTexto ftgd = new FicheroTexto();
    private Reloj_Sideral rj = new Reloj_Sideral();
    private FechaHora fh = new FechaHora();
    private GregorianCalendar gcdia = new GregorianCalendar();

    public Procesa_Ficheros_RMOB(boolean form_visible) {
        this.form_visible = form_visible;
    }

    private double convierte_coordenada(String s) throws Exception {
        double dato = 0.0;
        int grados = Integer.parseInt(s.substring(0, 3));
        int minutos = Integer.parseInt(s.substring(4, 6));
        int segundos = Integer.parseInt(s.substring(6, 8));
        String direccion = s.substring(9);
        double signo = 1.0;
        if (direccion.equals("W") || direccion.equals("S")) {
            signo = -1.0;
        }
        dato = signo * ((double)grados + (double)minutos / 60.0 + (double)segundos / 3600.0);
        return dato;
    }

    private boolean contiene_un_numero(String s) throws Exception {
        boolean aux = false;
        for (int i = 0; i < 10; ++i) {
            aux = aux || s.contains(String.valueOf(i));
        }
        return aux;
    }

    private int get_datos(String nombre, double[] dato) {
        int resultado = 0;
        try {
            boolean londata;
            boolean latdata;
            block35: {
                String linea = "";
                double long_gms = 0.0;
                double long_gmap = 0.0;
                double lat_gms = 0.0;
                double lat_gmap = 0.0;
                this.ftgd.asigna_nombre_lectura(nombre);
                resultado = 0;
                boolean latgmsdata = false;
                boolean longgmsdata = false;
                boolean latgmapdata = false;
                boolean longgmapdata = false;
                latdata = false;
                londata = false;
                if (nombre != null) {
                    try {
                        boolean c = false;
                        while (!this.ftgd.fin) {
                            linea = this.ftgd.leer_linea();
                            if (linea.length() > 11) {
                                try {
                                    if (linea.substring(0, 11).equals("[Longitude]")) {
                                        long_gms = this.convierte_coordenada(linea.substring(11));
                                        longgmsdata = true;
                                        RaMAP.pantalla.ventanalog.log_depuracion("Longitude GMS found.");
                                    }
                                }
                                catch (Exception ex) {
                                    RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                                    RaMAP.pantalla.ventanalog.log("Error getting [Longitude]");
                                    RaMAP.pantalla.ventanalog.log("Exception: " + ex.toString());
                                }
                                try {
                                    if (linea.substring(0, 11).equals("[Latitude ]")) {
                                        lat_gms = this.convierte_coordenada(linea.substring(11));
                                        RaMAP.pantalla.ventanalog.log_depuracion("Latitude GMS found.");
                                        latgmsdata = true;
                                    }
                                }
                                catch (Exception ex) {
                                    RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                                    RaMAP.pantalla.ventanalog.log("Error getting [Latitude]");
                                    RaMAP.pantalla.ventanalog.log("Exception: " + ex.toString());
                                }
                            }
                            if (linea.length() > 16) {
                                try {
                                    if (linea.substring(0, 16).equals("[Longitude GMAP]")) {
                                        long_gmap = Double.parseDouble(linea.substring(16));
                                        RaMAP.pantalla.ventanalog.log_depuracion("Longitude GMAP found.");
                                        longgmapdata = true;
                                    }
                                }
                                catch (Exception ex) {
                                    RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                                    RaMAP.pantalla.ventanalog.log("Error getting [Longitude GMAP]");
                                    RaMAP.pantalla.ventanalog.log("Exception: " + ex.toString());
                                }
                            }
                            if (linea.length() > 15) {
                                try {
                                    if (linea.substring(0, 15).equals("[Latitude GMAP]")) {
                                        lat_gmap = Double.parseDouble(linea.substring(15));
                                        RaMAP.pantalla.ventanalog.log_depuracion("Latitude GMAP found.");
                                        latgmapdata = true;
                                    }
                                }
                                catch (Exception ex) {
                                    RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                                    RaMAP.pantalla.ventanalog.log("Error getting [Latitude GMAP]");
                                    RaMAP.pantalla.ventanalog.log("Exception: " + ex.toString());
                                }
                            }
                            if (linea.length() > 16) {
                                try {
                                    if (linea.substring(0, 16).equals("[Azimut Antenna]")) {
                                        if (this.contiene_un_numero(linea.substring(16))) {
                                            dato[2] = Double.parseDouble(linea.substring(16));
                                        }
                                        RaMAP.pantalla.ventanalog.log_depuracion("Azimut Antenna found.");
                                    }
                                }
                                catch (Exception ex) {
                                    RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                                    RaMAP.pantalla.ventanalog.log("Error getting [Azimut Antenna]");
                                    RaMAP.pantalla.ventanalog.log("Exception: " + ex.toString());
                                }
                            }
                            if (linea.length() <= 19) continue;
                            try {
                                if (!linea.substring(0, 19).equals("[Elevation Antenna]")) continue;
                                if (this.contiene_un_numero(linea.substring(19))) {
                                    dato[3] = Double.parseDouble(linea.substring(19));
                                }
                                RaMAP.pantalla.ventanalog.log_depuracion("Elevation Antenna found.");
                            }
                            catch (Exception ex) {
                                RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                                RaMAP.pantalla.ventanalog.log("Error getting [Elevation Antenna]");
                                RaMAP.pantalla.ventanalog.log("Exception: " + ex.toString());
                            }
                        }
                        if (longgmapdata) {
                            dato[0] = long_gmap;
                            londata = true;
                        } else if (longgmsdata) {
                            dato[0] = long_gms;
                            londata = true;
                        }
                        if (latgmapdata) {
                            dato[1] = lat_gmap;
                            latdata = true;
                        } else if (latgmsdata) {
                            dato[1] = lat_gms;
                            latdata = true;
                        }
                        this.ftgd.cerrar_fichero_entrada();
                    }
                    catch (Exception e) {
                        RaMAP.pantalla.ventanalog.log("EXCEPTION: Method: <get_datos>:" + e.toString());
                        RaMAP.pantalla.ventanalog.log("File name: " + nombre);
                        RaMAP.pantalla.ventanalog.log("Longitude GMS: " + String.valueOf(long_gms));
                        RaMAP.pantalla.ventanalog.log("Latitude GMS: " + String.valueOf(lat_gms));
                        RaMAP.pantalla.ventanalog.log("Longitude GMAP: " + String.valueOf(long_gmap));
                        RaMAP.pantalla.ventanalog.log("Latitude GMAP: " + String.valueOf(lat_gmap));
                        RaMAP.pantalla.ventanalog.log("Azimut Antenna: " + String.valueOf(dato[2]));
                        RaMAP.pantalla.ventanalog.log("Elevation Antenna: " + String.valueOf(dato[3]));
                        RaMAP.pantalla.ventanalog.log_tracktrace(e);
                        if (this.ftgd.eof()) break block35;
                        this.ftgd.cerrar_fichero_entrada();
                    }
                }
            }
            resultado = latdata & londata ? 0 : 1;
            return resultado;
        }
        catch (Exception e) {
            RaMAP.pantalla.ventanalog.log("EXCEPTION: Class: <MAPFileProcess> Method: <get_datos>");
            RaMAP.pantalla.ventanalog.log_tracktrace(e);
            this.mb.SetMessage("***************\n** EXCEPTION **\n***************\n\nCLASS: <MAPView>\n\nMETHOD: <pantalla_skm>\n\nMESSAGE: " + e.toString());
            return 1;
        }
    }

    private int[] calcula_offsets(double azimut, double elevacion) throws Exception {
        int[] off = new int[2];
        int x = 0;
        int y = 0;
        if (this.apply_antenna_settings) {
            if (elevacion > 45.0) {
                x = 0;
                y = 0;
            } else {
                if (azimut > 337.5 || azimut <= 22.5) {
                    x = 0;
                    ++y;
                }
                if (azimut > 22.5 & azimut <= 67.5) {
                    ++x;
                    ++y;
                }
                if (azimut > 67.5 & azimut <= 112.5) {
                    ++x;
                    y = 0;
                }
                if (azimut > 112.5 & azimut <= 157.5) {
                    ++x;
                    --y;
                }
                if (azimut > 157.5 & azimut <= 202.5) {
                    x = 0;
                    --y;
                }
                if (azimut > 202.5 & azimut <= 247.5) {
                    --x;
                    --y;
                }
                if (azimut > 247.5 & azimut <= 292.5) {
                    --x;
                    y = 0;
                }
                if (azimut > 292.5 & azimut <= 337.5) {
                    // empty if block
                }
            }
        }
        off[0] = --x;
        off[1] = ++y;
        return off;
    }

    private void procesa_dia(StringTokenizer linea, int year, int mes, double longitud, double latitud, double azimut, double elevacion, Medidas_de_Dispersion medidas, FicheroTexto fs) {
        int cifra = 0;
        int[] offsets = new int[2];
        int diax = 1;
        int h = 0;
        double lst = 0.0;
        try {
            Celda c = new Celda();
            String aux = linea.nextToken("|").trim();
            diax = Integer.parseInt(aux);
            this.gcdia.set(year, mes - 1, diax, 0, 0, 0);
            for (h = 0; h < 24; ++h) {
                aux = linea.nextToken("|").trim();
                if (aux.equals("???") || aux.equals("--")) {
                    c.set_datos(1, 0, medidas);
                    continue;
                }
                cifra = Integer.parseInt(aux.trim());
                c.set_datos(1, cifra, medidas);
                lst = this.rj.calcula_hora_sideral(longitud, year, mes, diax, h, 30, 0.0);
                if (lst > 24.0) {
                    lst -= 24.0;
                }
                offsets = this.calcula_offsets(azimut, elevacion);
                String linea_salida = "";
                GregorianCalendar gcf = new GregorianCalendar(year, mes - 1, diax, h, 30, 0);
                linea_salida = this.fh.presenta_junto_AMDHMS(gcf) + ";" + String.valueOf(lst) + ";" + String.valueOf(latitud) + ";" + String.valueOf(azimut) + ";" + String.valueOf(elevacion) + ";" + String.valueOf(c.numero_de_observadores) + ";" + String.valueOf(c.conteo_total) + ";" + String.valueOf(c.estimacion) + ";" + String.valueOf(c.conteo_relativo) + ";" + String.valueOf(c.estimacion_relativa) + ";" + String.valueOf(medidas.media) + ";" + String.valueOf(medidas.maximo) + ";" + String.valueOf(medidas.minimo) + ";" + String.valueOf(medidas.desviacion_estandard) + ";" + String.valueOf(medidas.numero_de_entradas_invalidas) + ";" + String.valueOf(medidas.datos_validos ? "True" : "False");
                fs.escribir_linea(linea_salida);
            }
        }
        catch (Exception e) {
            RaMAP.pantalla.ventanalog.log("EXCEPTION: Class <MAPFileProcess> : Method <procesa_dia> :");
            RaMAP.pantalla.ventanalog.log("Year: " + String.valueOf(year) + "  Month: " + String.valueOf(mes) + "  Day: " + String.valueOf(diax) + "  Hour: " + String.valueOf(h) + "  LST: " + String.valueOf(lst) + "  latitud: " + String.valueOf(latitud) + "  offsets[0]: " + String.valueOf(offsets[0]) + "  offsets[1]: " + String.valueOf(offsets[1]));
            RaMAP.pantalla.ventanalog.log_tracktrace(e);
        }
    }

    public int[] cadena_mes_year_a_enteros(String mmyyyy) throws Exception {
        int[] my = new int[2];
        String mm = mmyyyy.substring(0, 2);
        String yy = mmyyyy.substring(2, 6);
        my[0] = Integer.parseInt(mm);
        my[1] = Integer.parseInt(yy);
        return my;
    }

    private String cadena_mes_year(String name) throws Exception {
        String mmyyyy = "";
        String aux = "";
        aux = name.substring(name.length() - 14);
        mmyyyy = aux.substring(0, 2) + aux.substring(2, 6);
        return mmyyyy;
    }

    private void pasa_mes_de_datos_de_fichero_txt_a_DB(String rutaynombre) {
        block22: {
            Medidas_de_Dispersion medidas = new Medidas_de_Dispersion();
            double longitud = 0.0;
            double latitud = 0.0;
            double azimut = 0.0;
            double elevacion = 0.0;
            int indice = 0;
            int ultima_barra = 0;
            int c = 0;
            int res_ft = 0;
            boolean res_fsk = false;
            int res_fs = 0;
            int[] my = new int[2];
            int result_location = 0;
            String[] dias = new String[32];
            String linea = "";
            String nombre = "";
            try {
                RaMAP.pantalla.ventanalog.log_depuracion("File input: " + rutaynombre);
                medidas = this.frmob.get_medidas_de_dispersion(rutaynombre);
                RaMAP.pantalla.ventanalog.log_depuracion("Sample average: " + String.valueOf(medidas.media));
                res_ft = this.ft.asigna_nombre_lectura(rutaynombre);
                indice = rutaynombre.indexOf(".txt", rutaynombre.length() - 5);
                if (indice <= 0) {
                    indice = rutaynombre.indexOf(".TXT", rutaynombre.length() - 5);
                }
                ultima_barra = rutaynombre.lastIndexOf(System.getProperty("file.separator"));
                nombre = rutaynombre.substring(ultima_barra + 1, indice);
                my = this.cadena_mes_year_a_enteros(this.cadena_mes_year(rutaynombre));
                int m = my[0];
                int y = my[1];
                double[] auxiliar = new double[4];
                result_location = this.get_datos(rutaynombre, auxiliar);
                longitud = auxiliar[0];
                latitud = auxiliar[1];
                azimut = auxiliar[2];
                elevacion = auxiliar[3];
                if (result_location == 0) {
                    RaMAP.pantalla.ventanalog.log_depuracion("Longitude: " + String.valueOf(longitud) + " Latitude: " + String.valueOf(latitud) + " Azimut: " + String.valueOf(azimut) + " Elevation: " + String.valueOf(elevacion));
                    RaMAP.pantalla.ventanalog.log_depuracion("Processing file...");
                    if (rutaynombre != null) {
                        c = 0;
                        while (!this.ft.fin) {
                            if (!(c < 32 & (linea = this.ft.leer_linea()).length() > 0) || linea.charAt(0) != ' ') continue;
                            dias[c] = linea;
                            ++c;
                            RaMAP.pantalla.ventanalog.log_depuracion(linea);
                        }
                    }
                } else {
                    RaMAP.pantalla.ventanalog.log("The selected file does not have location data.");
                    RaMAP.pantalla.ventanalog.log("File input: " + rutaynombre);
                }
                if (indice > 0 & res_ft == 0 & result_location == 0) {
                    this.rutaynombre_skm = rutaynombre.substring(0, indice) + ".skm";
                    if (RaMAP.program_status == 1) {
                        this.rutaynombre_txt = RaMAP.last_realtime_directory_db + nombre + "_DB.txt";
                    }
                    if (RaMAP.program_status == 0) {
                        this.rutaynombre_txt = RaMAP.last_directory_db + nombre + "_DB.txt";
                    }
                    res_fs = this.fs.asigna_nombre_escritura(this.rutaynombre_txt);
                    RaMAP.pantalla.ventanalog.log_depuracion("File output: " + this.rutaynombre_skm);
                    RaMAP.pantalla.ventanalog.log_depuracion("File output: " + this.rutaynombre_txt);
                    if (res_fsk || res_fs != 0) {
                        RaMAP.pantalla.ventanalog.log("Problem assigning name to output file.");
                        if (res_fsk) {
                            RaMAP.pantalla.ventanalog.log("File output: " + this.rutaynombre_skm);
                        }
                        if (res_fs != 0) {
                            RaMAP.pantalla.ventanalog.log("File output: " + this.rutaynombre_txt);
                        }
                    } else {
                        String cadaux = "";
                        String linea_salida = "Time_UTC;Right_Ascension;Declination;Antenna_Azimut;Antenna_Elevation;Number_of_Observers;Total_Count;Average;Relative_Count;Relative_Count_Average;Monthly_Average;Monthly_Maximum;Monthly_Minimum;Monthly_Standard_Deviation;Monthly_Number_of_Invalid_Entries;Valid_data";
                        this.fs.escribir_linea(linea_salida);
                        for (int i = 0; i < c; ++i) {
                            cadaux = dias[i].substring(0, 3).trim();
                            if (Integer.parseInt(cadaux) >= 32) continue;
                            StringTokenizer s = new StringTokenizer(dias[i]);
                            this.procesa_dia(s, y, m, longitud, latitud, azimut, elevacion, medidas, this.fs);
                        }
                        this.ft.cerrar_fichero_entrada();
                        this.fs.cerrar_fichero_salida();
                        RaMAP.pantalla.ventanalog.log_depuracion("File processed.");
                    }
                } else {
                    RaMAP.pantalla.ventanalog.log("File '" + rutaynombre.substring(0, indice) + "_DB.txt'" + "not generated,");
                    RaMAP.pantalla.ventanalog.log("Due to:");
                    if (indice == 0) {
                        RaMAP.pantalla.ventanalog.log("RMOB file not ending in 'txt' or 'TXT'.");
                    }
                    if (res_ft != 0) {
                        RaMAP.pantalla.ventanalog.log("Probleme opening RMOB file.");
                    }
                    if (result_location != 0) {
                        RaMAP.pantalla.ventanalog.log("Problem getting parameters (eg. location...).");
                    }
                }
            }
            catch (Exception e) {
                RaMAP.pantalla.ventanalog.log("EXCEPTION: Class <MAPFileProcess> : Method <pasa_mes_de_datos_de_fichero_txt_a_DB> : ");
                RaMAP.pantalla.ventanalog.log("File input: " + rutaynombre);
                RaMAP.pantalla.ventanalog.log_tracktrace(e);
                if (!medidas.datos_validos) break block22;
                RaMAP.pantalla.ventanalog.log("Sample average: " + String.valueOf(medidas.media));
                RaMAP.pantalla.ventanalog.log("Longitude: " + String.valueOf(longitud) + " Latitude: " + String.valueOf(latitud) + " Azimut: " + String.valueOf(azimut) + " Elevation: " + String.valueOf(elevacion));
                RaMAP.pantalla.ventanalog.log("Line: " + linea);
                RaMAP.pantalla.ventanalog.log_tracktrace(e);
                try {
                    if (res_ft == 0 & !this.ft.eof()) {
                        this.ft.cerrar_fichero_entrada();
                    }
                }
                catch (Exception ex1) {
                    RaMAP.pantalla.ventanalog.log("EXCEPTION: Class <MAPView> : Method <pasa_mes_de_datos_de_fichero_txt_a_DB> : ");
                    RaMAP.pantalla.ventanalog.log("Line: " + linea);
                    RaMAP.pantalla.ventanalog.log_tracktrace(ex1);
                }
            }
        }
    }

    private void pasa_datos_a_DB_txt(FicheroTexto sal, String ruta, String nombre) {
        try {
            FicheroTexto ent = new FicheroTexto();
            ent.asigna_nombre_lectura(ruta);
            ent.leer_linea();
            String quality_factor = "1.0";
            String finlinea = ";" + nombre + ";" + quality_factor;
            boolean c = false;
            while (!ent.eof()) {
                String linea = ent.leer_linea();
                if (linea.length() <= 0) continue;
                linea = linea + finlinea;
                sal.escribir_linea(linea);
            }
            ent.cerrar_fichero_entrada();
        }
        catch (Exception e) {
            RaMAP.pantalla.ventanalog.log("EXCEPTION: Class: <MAPFileProcess>");
            RaMAP.pantalla.ventanalog.log("Method: <pasa_datos_a_DB_txt>");
            RaMAP.pantalla.ventanalog.log_tracktrace(e);
        }
    }

    public void procesa_directorio_txt_realtime() {
        FicheroTexto filesrmob = new FicheroTexto(this.form_visible);
        int i = 0;
        boolean processing_files = false;
        try {
            filesrmob.ruta = RaMAP.last_realtime_directory_rmob;
            filesrmob.seleccionar_fichero();
            boolean a = filesrmob.ruta.isEmpty();
            RaMAP.pantalla.ventanalog.log("RMOB Path: " + filesrmob.ruta);
            if (!filesrmob.ruta.isEmpty() & filesrmob.ficheros != null) {
                if (filesrmob.ficheros.length > 0) {
                    RaMAP.last_directory_rmob = filesrmob.ruta;
                    for (i = 0; i < filesrmob.ficheros.length; ++i) {
                        processing_files = true;
                        this.progreso = Math.round((float)(i + 1) * 100.0f / ((float)filesrmob.ficheros.length * 1.0f));
                        RaMAP.pantalla.progb.setValue(this.progreso);
                        RaMAP.pantalla.progb.repaint();
                        if (!filesrmob.ficheros[i].contains("rmob.TXT") && !filesrmob.ficheros[i].contains("rmob.txt")) continue;
                        RaMAP.pantalla.ventanalog.log_depuracion(filesrmob.ficheros[i]);
                        RaMAP.pantalla.ventanalog.log_depuracion("Processing file: " + filesrmob.ruta + filesrmob.ficheros[i]);
                        this.pasa_mes_de_datos_de_fichero_txt_a_DB(filesrmob.ruta + filesrmob.ficheros[i]);
                    }
                    processing_files = false;
                    RaMAP.pantalla.progb.setValue(0);
                }
            } else {
                RaMAP.pantalla.ventanalog.log("Process not done.\nEither path is empty, or there is not files in that path.");
            }
        }
        catch (Exception e) {
            RaMAP.pantalla.ventanalog.log("EXCEPTION: Class: <MAPFileProcess>.");
            RaMAP.pantalla.ventanalog.log("Method: <procesa_directorio_txt>");
            if (processing_files) {
                RaMAP.pantalla.ventanalog.log(filesrmob.ficheros[i]);
            }
            RaMAP.pantalla.ventanalog.log_tracktrace(e);
        }
    }

    public void procesa_directorio_txt() {
        String rutnom = "";
        FicheroTexto filesrmob = new FicheroTexto();
        int i = 0;
        RaMAP.pantalla.ventanalog.log("------------------------------------------------------------------------------------------------");
        RaMAP.pantalla.ventanalog.log("Processing RMOB files");
        RaMAP.pantalla.ventanalog.log("---------------------");
        try {
            filesrmob.ruta = RaMAP.last_directory_rmob;
            RaMAP.pantalla.ventanalog.log("Last RMOB directory: " + filesrmob.ruta);
            filesrmob.seleccionar_ficheros();
            if (!filesrmob.ruta.isEmpty() & filesrmob.lista.length > 0) {
                RaMAP.last_directory_rmob = filesrmob.ruta;
                for (i = 0; i < filesrmob.lista.length; ++i) {
                    this.progreso = Math.round((float)(i + 1) * 100.0f / ((float)filesrmob.lista.length * 1.0f));
                    RaMAP.pantalla.progb.setValue(this.progreso);
                    RaMAP.pantalla.progb.repaint();
                    if (!filesrmob.lista[i].getName().contains("rmob.TXT") && !filesrmob.lista[i].getName().contains("rmob.txt")) continue;
                    RaMAP.pantalla.ventanalog.log(filesrmob.lista[i].getName());
                    RaMAP.pantalla.ventanalog.log_depuracion("Processing file: " + filesrmob.ruta + filesrmob.lista[i]);
                    this.pasa_mes_de_datos_de_fichero_txt_a_DB(filesrmob.ruta + filesrmob.lista[i].getName());
                }
                RaMAP.pantalla.ventanalog.log("------------------------------------------------------------------------------------------------");
                RaMAP.pantalla.ventanalog.log("RMOB Files process finished.");
                RaMAP.pantalla.progb.setValue(0);
            }
        }
        catch (Exception e) {
            RaMAP.pantalla.ventanalog.log("EXCEPTION: Class: <MAPFileProcess>.");
            RaMAP.pantalla.ventanalog.log("Method: <procesa_directorio_txt>");
            RaMAP.pantalla.ventanalog.log_tracktrace(e);
        }
    }

    private int minimo(int a, int b) throws Exception {
        int c = a;
        if (b < c) {
            return b;
        }
        return c;
    }

    @Override
    public void run() {
        if (this.form_visible) {
            RaMAP.MAP_File_Process_End = false;
            this.procesa_directorio_txt();
            RaMAP.MAP_File_Process_End = true;
        } else {
            this.procesa_directorio_txt_realtime();
            RaMAP.pantalla.realtime.procesa_archivos_DB_en_Real_Time();
            RaMAP.MAP_File_Process_End = true;
        }
    }

    public void main(boolean explore_files) {
        new Thread((Runnable)new Procesa_Ficheros_RMOB(explore_files), "Process_Dir_TXT").start();
    }
}

