/*
 * Decompiled with CFR 0.152.
 */
package rmap.pkg0;

import astronomia.Reloj_Sideral;
import cadenas.Cadena;
import cadenas.FechaHora;
import cadenas.Justifica;
import ficheros.FicheroTexto;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import report.MessageBox;
import report.Ventana_de_Log;
import rmap.pkg0.AcercaDe;
import rmap.pkg0.Array_de_Skymaps;
import rmap.pkg0.Celda;
import rmap.pkg0.ConjuntoDatos;
import rmap.pkg0.Constelacion;
import rmap.pkg0.Constelaciones;
import rmap.pkg0.CorrienteMeteorica;
import rmap.pkg0.Corrientes;
import rmap.pkg0.DatosMarco;
import rmap.pkg0.Datos_del_Programa;
import rmap.pkg0.DescargaRMOB;
import rmap.pkg0.Enlace;
import rmap.pkg0.Estrella;
import rmap.pkg0.Estrellas;
import rmap.pkg0.FicheroSkymap;
import rmap.pkg0.Help;
import rmap.pkg0.Lugares;
import rmap.pkg0.Medidas_de_Dispersion;
import rmap.pkg0.Nombre_de_Fichero_DB;
import rmap.pkg0.Paleta_de_Colores;
import rmap.pkg0.Procesa_Ficheros_RMOB;
import rmap.pkg0.RaMAP;
import rmap.pkg0.Skymap;

public class Pantalla
extends JFrame {
    static final long serialVersionUID = 100001L;
    private MessageBox mb = new MessageBox();
    static int CARTESIAN_PROJECTION = 1;
    static int ELLIPTIC_PROJECTION = 2;
    static int ON_THE_EARTH = 1;
    static int BEHIND_THE_STARS = 2;
    static int MATCH_MONTH_AND_YEAR = 1;
    static int MATCH_MONTH = 2;
    static int MATCH_YEAR = 3;
    static int SKY_BLACK = 0;
    static int SKY_WHITE = 1;
    private Skymap skscr = new Skymap();
    private Array_de_Skymaps mskmaps = new Array_de_Skymaps();
    public int registro = 1;
    private int tipo_salida = Skymap.ESTIMACION_RELATIVA;
    public Ventana_de_Log ventanalog = new Ventana_de_Log();
    private int tipo_color = 2;
    private float nivel_color = 1.0f;
    private int tipo_de_proyeccion = CARTESIAN_PROJECTION;
    private int tipo_de_punto_de_vista = ON_THE_EARTH;
    private int altura_etiqueta_ar = 5;
    private int altura_etiqueta_grados = 10;
    private int ejex = 0;
    private int ejey = 0;
    private int orx = 35;
    private int ory = 140;
    private int desp_x = 0;
    private int prox = 0;
    private int proy = 0;
    private int marca_horaria = 0;
    private int marca_grados = 0;
    private int saltox = 1;
    private int ardeg = 0;
    private int arhor = 0;
    private int anchox;
    private int anchoy;
    private int espaciox = 0;
    private int espacioy = 0;
    private Estrellas firmamento = new Estrellas();
    private Constelaciones zoodiaco = new Constelaciones();
    private Corrientes lluvias = new Corrientes();
    private Lugares sitios = new Lugares();
    private int color_del_cielo = SKY_WHITE;
    public boolean seleccionar_archivos = false;
    private boolean grid = true;
    private boolean streams = true;
    private boolean constellations = true;
    private boolean stars = true;
    private boolean sites = true;
    private Menu archivo = new Menu();
    private Menu imagen = new Menu();
    private Menu logm = new Menu();
    private Menu realT = new Menu();
    private Menu help = new Menu();
    private MenuBar menu = new MenuBar();
    private JTextField nobs_box = new JTextField("1");
    private Button recordinf = new Button("<-");
    private Label record = new Label("Record");
    private Button recordsup = new Button("->");
    private Label numobs = new Label("#Obs>=");
    private Label intensity = new Label("Intensity");
    private Button down = new Button("Down");
    private JTextField nivel_color_box = new JTextField("1.0");
    private Button up = new Button("Up");
    private Choice output_type_selection_list = new Choice();
    public JPanel panel = new JPanel();
    private Label initdate = new Label("Init Date: Year");
    private JTextField yearbox = new JTextField("2012");
    private Label mes = new Label("Month");
    private Choice monthbox = new Choice();
    private Label dia = new Label("Day");
    private Choice daybox = new Choice();
    private Label hora = new Label("Hour");
    private Choice hourbox = new Choice();
    private Label shift = new Label("Shift");
    private JTextField incbox = new JTextField("24");
    private Label periodo = new Label("Period");
    private JTextField periodbox = new JTextField("24");
    private Label pt = new Label("Hours.  #Recs");
    private JTextField registrosbox = new JTextField("  31");
    private Button process_button = new Button("Proc");
    public JProgressBar progb = new JProgressBar();
    private boolean image_loop = false;
    private int interval = 1000;
    public int last_skymap = 0;
    private int utc_diff = 0;
    private GregorianCalendar lastdate = new GregorianCalendar();
    private GregorianCalendar HoraActual = new GregorianCalendar();
    private FechaHora HoraActualenCristiano = new FechaHora();
    private procesa_directorio_DB ProcDir_DB = new procesa_directorio_DB();
    public String ruta_de_la_aplicacion = "";
    private String rutanomlog = "";
    private String filename_skm = "";
    public String last_directory_skm = "";
    public String last_directory_rmob = "";
    public String last_directory_db = "";
    private String ruta_fic_config = "";
    private String nombre_fic_config = "";
    private String nombre_fic_corrientes = "";
    private String nombre_fic_lugares = "";
    public String rlt_directory_skm = "";
    public String rlt_directory_rmob = "";
    public String rlt_directory_db = "";
    public String rlt_directory_current_image = "";
    public String rlt_directory_overlay = "";
    public String rmob_data_source = "";
    public RealTime realtime = new RealTime();
    private String separador = System.getProperty("file.separator");
    Timer reloj = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int dif = RaMAP.pantalla.utc_diff * -1;
            Pantalla.this.HoraActual.setTimeInMillis(System.currentTimeMillis());
            Pantalla.this.HoraActual.add(11, dif);
            RaMAP.pantalla.setTitle("RaMAP 1.7         " + Pantalla.this.HoraActualenCristiano.presenta_hora(Pantalla.this.HoraActual));
        }
    });
    Timer temporizador_proceso_en_tiempo_real = new Timer(1800000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RaMAP.Descarga_Archivos_RMOB_Process_End & RaMAP.MAP_File_Process_End & RaMAP.DB_Files_Process_End) {
                Pantalla.this.comprueba_cambio_de_dia();
                Pantalla.this.ventanalog.cls();
                Pantalla.this.realtime.run();
            }
        }
    });
    Timer temporizador_image_loop = new Timer(this.interval, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Pantalla.this.registro_siguiente();
            if (Pantalla.this.registro + 1 == Pantalla.this.last_skymap) {
                Pantalla.this.temporizador_image_loop.setDelay(Pantalla.this.interval * 2);
            } else {
                Pantalla.this.temporizador_image_loop.setDelay(Pantalla.this.interval);
            }
        }
    });

    public Pantalla() {
        this.elementos_de_la_ventana();
        this.inicia_demas_componentes();
        try {
            Datos_del_Programa dp = new Datos_del_Programa();
            this.ruta_de_la_aplicacion = dp.ruta_de_ejecucion_del_programa();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ruta_fic_config = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "cfg" + System.getProperty("file.separator");
        this.nombre_fic_config = this.ruta_fic_config + "rmap.cfg";
        this.nombre_fic_corrientes = this.ruta_fic_config + "streams.cfg";
        this.nombre_fic_lugares = this.ruta_fic_config + "sites.cfg";
        this.last_directory_skm = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "skm" + System.getProperty("file.separator");
        this.last_directory_rmob = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "rmb" + System.getProperty("file.separator");
        this.last_directory_db = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "dat" + System.getProperty("file.separator");
        this.actualiza_nombre_logfile();
        this.ventanalog.log("Loading configuration file.");
        this.carga_archivo_de_configuracion();
        this.ventanalog.log("Program started.");
        this.ventanalog.log("Execution path: " + this.ruta_de_la_aplicacion);
        this.ventanalog.log("SKM Directory: " + this.last_directory_skm);
        this.ventanalog.log("RMOB Directory: " + this.last_directory_rmob);
        this.ventanalog.log("DB Directory: " + this.last_directory_db);
        this.panel.setOpaque(true);
        this.reloj.start();
    }

    private void comprueba_cambio_de_dia() {
        GregorianCalendar now = new GregorianCalendar();
        if (now.get(5) == this.lastdate.get(5) + 1 || now.get(5) == 1 & this.lastdate.get(5) > 1) {
            this.actualiza_nombre_logfile();
        }
        this.lastdate.setTime(now.getTime());
    }

    private void actualiza_nombre_logfile() {
        try {
            GregorianCalendar gc = new GregorianCalendar();
            FechaHora fh = new FechaHora();
            this.ventanalog.log("Updating log file name to: Program_log_" + fh.presenta_junto_AMDHMS(gc) + ".txt");
            this.rutanomlog = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "log" + System.getProperty("file.separator") + "Program_log_" + fh.presenta_junto_AMDHMS(gc) + ".txt";
            if (this.ventanalog.salfic.FicheroSalidaActivo()) {
                this.ventanalog.salfic.cerrar_fichero_salida();
            }
            this.ventanalog.salfic.asigna_nombre_escritura(this.rutanomlog);
            this.ventanalog.cls();
            this.ventanalog.log("New log created.");
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: actualiza_nombre_logfile");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private String get_program_path() {
        String nombre = "";
        try {
            String cadena_entera = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            int ultimabarra = cadena_entera.lastIndexOf(System.getProperty("file.separator"));
            if (ultimabarra > 0 & cadena_entera.length() > ultimabarra) {
                nombre = cadena_entera.substring(0, ultimabarra);
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: get_program_path()");
            this.ventanalog.log_tracktrace(e);
            return "";
        }
        return nombre;
    }

    public Pantalla(Array_de_Skymaps msk) {
        try {
            this.mskmaps = msk;
            this.inicia_demas_componentes();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: Constructor");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void inicia_demas_componentes() {
        try {
            this.ventanalog.set_language(Ventana_de_Log.ENGLISH);
            this.ventanalog.setTitle("Skymap Screen Log");
            RaMAP.program_status = 0;
            this.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <inicia_demas_componentes>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public void setFileName(String fileName) {
        try {
            this.filename_skm = fileName;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <setFileName>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private int minimo(int a, int b) {
        try {
            int c = a;
            if (b < c) {
                return b;
            }
            return c;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <minimo>");
            this.ventanalog.log_tracktrace(e);
            return 0;
        }
    }

    public void setMesSkymaps(Array_de_Skymaps msk) {
        try {
            this.mskmaps = msk;
            Graphics g = this.panel.getGraphics();
            this.dibuja(g);
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <setMesSkymaps>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void registro_siguiente() {
        try {
            ++this.registro;
            if (this.registro <= 120) {
                if (!this.mskmaps.array_de_Skymaps[this.registro - 1].usado) {
                    this.last_skymap = this.registro - 2 + 1;
                    this.registro = 1;
                }
            } else {
                this.registro = 1;
            }
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <registro_siguiente>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void registro_anterior() {
        try {
            --this.registro;
            if (this.registro < 1) {
                this.registro = this.last_skymap == 0 ? 1 : this.last_skymap;
            }
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <registro_anterior>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public Array_de_Skymaps getMesSkymaps() {
        return this.mskmaps;
    }

    private void change_projection() {
        try {
            ++this.tipo_de_proyeccion;
            if (this.tipo_de_proyeccion > 2) {
                this.tipo_de_proyeccion = 1;
            }
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <change_projection>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void change_palette() {
        try {
            ++this.tipo_color;
            if (this.tipo_color == 4) {
                this.tipo_color = 1;
            }
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <change_palette>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void change_point_of_view() {
        try {
            ++this.tipo_de_punto_de_vista;
            if (this.tipo_de_punto_de_vista > 2) {
                this.tipo_de_punto_de_vista = 1;
            }
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <change_point_of_view>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void presenta_mapa_en_texto(Skymap sk, int sal) {
        try {
            int x;
            int y;
            Celda c = new Celda();
            String aux = "";
            FechaHora hh = new FechaHora();
            GregorianCalendar gc = new GregorianCalendar();
            gc = sk.get_hora();
            this.ventanalog.log("Date: " + hh.presenta_hora(gc).substring(0, 10));
            if (sal == 1) {
                this.ventanalog.log("Number of Observers");
                aux = "";
                for (y = 35; y >= 0; --y) {
                    for (x = 0; x < 72; ++x) {
                        c = sk.get_celda(x, y);
                        aux = aux + String.valueOf(c.get_numero_de_observadores()) + " ";
                    }
                    this.ventanalog.log(aux);
                    aux = "";
                }
            }
            if (sal == 2) {
                this.ventanalog.log("Total Count");
                aux = "";
                for (y = 35; y >= 0; --y) {
                    for (x = 0; x < 72; ++x) {
                        c = sk.get_celda(x, y);
                        aux = aux + String.valueOf(c.get_conteo_total()) + " ";
                    }
                    this.ventanalog.log(aux);
                    aux = "";
                }
            }
            if (sal == 3) {
                this.ventanalog.log("Estimation");
                aux = "";
                for (y = 35; y >= 0; --y) {
                    for (x = 0; x < 72; ++x) {
                        c = sk.get_celda(x, y);
                        aux = aux + String.valueOf(c.get_estimacion()) + " ";
                    }
                    this.ventanalog.log(aux);
                    aux = "";
                }
            }
            if (sal == 4) {
                this.ventanalog.log("Relative Estimation");
                aux = "";
                for (y = 35; y >= 0; --y) {
                    for (x = 0; x < 72; ++x) {
                        c = sk.get_celda(x, y);
                        aux = aux + String.valueOf(c.get_porcentaje_relativo()) + " ";
                    }
                    this.ventanalog.log(aux);
                    aux = "";
                }
            }
            if (sal == 5) {
                this.ventanalog.log("Relative Count");
                aux = "";
                for (y = 35; y >= 0; --y) {
                    for (x = 0; x < 72; ++x) {
                        c = sk.get_celda(x, y);
                        aux = aux + String.valueOf(c.get_conteo_relativo()) + " ";
                    }
                    this.ventanalog.log(aux);
                    aux = "";
                }
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <presenta_mapa_en_texto>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private int dato_eje_x(double Ascension_Recta) {
        return this.orx + (int)((double)this.ejex * (1.0 - Ascension_Recta / 24.0));
    }

    private int dato_eje_y(double Declinacion) {
        return (int)((double)this.ejey * (1.0 - (Declinacion + 90.0) / 180.0));
    }

    private int[] obtiene_punto_en_pantalla(double AR, double Dec) {
        int[] punto_en_pantalla = new int[2];
        int x = 0;
        int y = 0;
        switch (this.tipo_de_punto_de_vista) {
            case 1: {
                x = this.orx + (int)((double)this.ejex * (1.0 - AR / 24.0));
                break;
            }
            case 2: {
                x = this.orx + (int)((double)this.ejex * (AR / 24.0));
            }
        }
        y = (int)((double)this.ejey * (1.0 - (Dec + 90.0) / 180.0));
        switch (this.tipo_de_proyeccion) {
            case 2: {
                double sejx = (double)this.ejex / 2.0;
                double sejy = (double)this.ejey / 2.0;
                double X = sejx * Math.sqrt(1.0 - Math.pow((sejy - (double)y) / sejy, 2.0));
                double dx = sejx - X * 1.0;
                x = (int)(dx + (double)x * (X / ((double)this.ejex / 2.0)));
                break;
            }
        }
        punto_en_pantalla[0] = x;
        punto_en_pantalla[1] = y += this.ory;
        return punto_en_pantalla;
    }

    private void dibuja_estrellas(Graphics g) {
        try {
            int x = 0;
            int y = 0;
            int m = 0;
            int intens = 0;
            int escala = 50;
            if (this.color_del_cielo == SKY_WHITE) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.white);
            }
            int[] punto = new int[2];
            for (int i = 0; i < this.firmamento.contador; ++i) {
                punto = this.obtiene_punto_en_pantalla(this.firmamento.estrellas[i].Right_Ascension, this.firmamento.estrellas[i].Declination);
                m = (int)this.firmamento.estrellas[i].Magnitude;
                intens = 10 + m != 0 ? escala / (10 + m) : escala;
                x = punto[0];
                y = punto[1];
                g.fillOval(x, y, intens, intens);
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <dibuja_estrellas>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void dibuja_constelacion(Graphics g, Constelacion c) {
        try {
            if (this.color_del_cielo == SKY_WHITE) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.white);
            }
            Estrella estrella1 = new Estrella();
            Estrella estrella2 = new Estrella();
            Enlace enlace = new Enlace();
            for (int i = 0; i < c.enlaces.length; ++i) {
                enlace = c.getEnlace(i);
                estrella1 = c.getEstrellas(enlace.extremo[0]);
                estrella2 = c.getEstrellas(enlace.extremo[1]);
                int[] punto1 = new int[2];
                punto1 = this.obtiene_punto_en_pantalla(estrella1.Right_Ascension, estrella1.Declination);
                int x1 = punto1[0];
                int y1 = punto1[1];
                int[] punto2 = new int[2];
                punto2 = this.obtiene_punto_en_pantalla(estrella2.Right_Ascension, estrella2.Declination);
                int x2 = punto2[0];
                int y2 = punto2[1];
                g.drawLine(x1, y1, x2, y2);
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <dibuja_constelacion>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void dibuja_constelaciones(Graphics g) {
        for (int i = 0; i < Constelaciones.NUMERO_DE_CONSTELACIONES; ++i) {
            this.dibuja_constelacion(g, this.zoodiaco.constelaciones[i]);
        }
    }

    private boolean lluvia_entra_en_fechas(CorrienteMeteorica cm) {
        boolean entra = false;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(this.mskmaps.array_de_Skymaps[this.registro - 1].get_hora().getTime());
        int mes_act = this.mskmaps.array_de_Skymaps[this.registro - 1].get_hora().get(2);
        int dia_act = this.mskmaps.array_de_Skymaps[this.registro - 1].get_hora().get(5);
        if ((mes_act > cm.getDateini().get(2) || mes_act == cm.getDateini().get(2) & dia_act >= cm.getDateini().get(5)) & (mes_act < cm.getDatefin().get(2) || mes_act == cm.getDatefin().get(2) & dia_act <= cm.getDatefin().get(5))) {
            entra = true;
        }
        return entra;
    }

    private void dibuja_lluvias(Graphics g) {
        int[] punto = new int[2];
        int i = 0;
        for (i = 0; i < this.lluvias.get_numero_de_corrientes(); ++i) {
            if (!this.lluvia_entra_en_fechas(this.lluvias.stream[i])) continue;
            punto = this.obtiene_punto_en_pantalla(this.lluvias.stream[i].getRA(), this.lluvias.stream[i].getDec());
            char[] img = new char[]{'*'};
            String rutapic = this.ruta_de_la_aplicacion + this.separador + "res" + this.separador + "stream.png";
            Image pic = Toolkit.getDefaultToolkit().getImage(rutapic);
            g.drawImage(pic, punto[0] - 25, punto[1] - 20, this);
        }
    }

    private void dibuja_sitios(Graphics g) {
        int[] punto = new int[2];
        int i = 0;
        g.setColor(Color.darkGray);
        GregorianCalendar fechahora = this.mskmaps.array_de_Skymaps[this.registro - 1].get_hora();
        Reloj_Sideral sd = new Reloj_Sideral();
        for (i = 0; i < this.sitios.getNumero_Actual_de_Localizaciones(); ++i) {
            double ar = sd.calcula_hora_sideral(this.sitios.localizacion[i].getLongitude(), fechahora);
            punto = this.obtiene_punto_en_pantalla(ar, this.sitios.localizacion[i].getLatitude());
            char[] img = new char[]{'*'};
            String rutapic = this.ruta_de_la_aplicacion + this.separador + "res" + this.separador + "site.png";
            Image pic = Toolkit.getDefaultToolkit().getImage(rutapic);
            g.drawImage(pic, punto[0] - 12, punto[1] - 12, this);
            g.drawString(this.sitios.localizacion[i].getName(), punto[0] + 10, punto[1] + 10);
        }
    }

    private String obtiene_color(int valor) {
        try {
            String codigocolor = "";
            codigocolor = this.color_del_cielo == SKY_WHITE ? "0xFFFFFF" : "0x000000";
            int rojo = 0;
            int verde = 0;
            int azul = 0;
            float aux1 = 0.0f;
            int aux2 = 0;
            boolean aux3 = false;
            int codigo = 0;
            Paleta_de_Colores paleta = new Paleta_de_Colores();
            aux1 = this.nivel_color * (float)valor;
            if (this.tipo_color == 1 && valor > 0) {
                aux2 = (int)(aux1 * 2.0f);
                rojo = aux2;
                if (rojo > 255) {
                    rojo = 255;
                }
                codigo = rojo * 256 * 256 + verde * 256 + azul;
                codigocolor = String.valueOf(codigo);
            }
            if (this.tipo_color == 2 && valor > 0) {
                aux2 = (int)(23.0f * aux1 / 100.0f);
                if (aux2 > 23) {
                    aux2 = 23;
                }
                codigo = paleta.color[aux2];
                codigocolor = String.valueOf(codigo);
            }
            if (this.tipo_color == 3 && valor > 0) {
                aux2 = (int)(aux1 * 2.0f);
                rojo = aux2;
                if (rojo > 255) {
                    rojo = 255;
                }
                azul = 255 - rojo;
                codigo = rojo * 256 * 256 + verde * 256 + azul;
                codigocolor = String.valueOf(codigo);
            }
            return codigocolor;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <obtiene_color>");
            this.ventanalog.log_tracktrace(e);
            return "";
        }
    }

    private void proyecciones(int x, int y) {
        try {
            switch (this.tipo_de_proyeccion) {
                case 1: {
                    this.desp_x = 0;
                    this.prox = x * (this.anchox + this.espaciox);
                    this.proy = (35 - y) * (this.anchoy + this.espacioy);
                    break;
                }
                case 2: {
                    this.prox = x * (this.anchox + this.espaciox);
                    this.proy = (35 - y) * (this.anchoy + this.espacioy);
                    int X = (int)((double)this.ejex / 2.0 * Math.sqrt(1.0 - Math.pow(((double)this.ejey / 2.0 - (double)this.proy) / ((double)this.ejey / 2.0), 2.0)));
                    this.desp_x = (int)((double)this.ejex / 2.0 - (double)X);
                    this.prox = (int)((double)(this.prox * X) / ((double)this.ejex / 2.0));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <proyecciones>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public boolean cumple_condicion(Celda c) {
        try {
            boolean aux = false;
            int nobs = 0;
            String nobscad = this.nobs_box.getText();
            if (!nobscad.isEmpty()) {
                Cadena nob = new Cadena(nobscad);
                if (nob.isIntNumber()) {
                    nobs = Integer.parseInt(nobscad);
                    this.nobs_box.setBackground(Color.white);
                    if (c.numero_de_observadores >= nobs) {
                        aux = true;
                    }
                } else {
                    this.nobs_box.setBackground(Color.red);
                }
            }
            return aux;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <cumple_condicion>");
            this.ventanalog.log_tracktrace(e);
            return false;
        }
    }

    private void dibuja_grid(int x, int y, Graphics g) {
        try {
            if (this.grid) {
                if (this.marca_grados == 1) {
                    if (this.color_del_cielo == SKY_WHITE) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.decode("0x00ff00"));
                    }
                    g.drawLine(this.orx + this.desp_x + this.prox, this.ory + this.proy, this.orx + this.desp_x + this.prox + this.anchox, this.ory + this.proy);
                }
                if (y == 0) {
                    if (this.color_del_cielo == SKY_WHITE) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(this.orx + this.desp_x + this.prox, this.ory + this.proy + this.anchoy, this.orx + this.desp_x + this.prox + this.anchox, this.ory + this.proy + this.anchoy);
                }
                ++this.marca_horaria;
                if ((this.marca_horaria == 1 || this.marca_horaria == 4) & this.tipo_de_punto_de_vista == BEHIND_THE_STARS) {
                    this.marca_horaria = 1;
                    if (this.color_del_cielo == SKY_WHITE) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(this.orx + this.desp_x + this.prox, this.ory + this.proy, this.orx + this.desp_x + this.prox, this.ory + this.proy + this.anchoy);
                }
                if ((this.marca_horaria == 0 || this.marca_horaria == 3) & this.tipo_de_punto_de_vista == ON_THE_EARTH) {
                    this.marca_horaria = 0;
                    if (this.color_del_cielo == SKY_WHITE) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(this.orx + this.desp_x + this.prox, this.ory + this.proy, this.orx + this.desp_x + this.prox, this.ory + this.proy + this.anchoy);
                }
                if (x == 71 & this.tipo_de_punto_de_vista == BEHIND_THE_STARS) {
                    if (this.color_del_cielo == SKY_WHITE) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(this.orx + this.desp_x + this.prox + this.anchox, this.ory + this.proy, this.orx + this.desp_x + this.prox + this.anchox, this.ory + this.proy + this.anchoy);
                }
                if (x == 0 & this.tipo_de_punto_de_vista == ON_THE_EARTH) {
                    if (this.color_del_cielo == SKY_WHITE) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    g.drawLine(this.orx + this.desp_x + this.prox + this.anchox, this.ory + this.proy, this.orx + this.desp_x + this.prox + this.anchox, this.ory + this.proy + this.anchoy);
                }
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <dibuja_grid>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private void dibuja_etiquetas(int x, int y, Graphics g) {
        try {
            if (y == 35) {
                ++this.saltox;
                if (this.saltox == 2) {
                    this.saltox = -1;
                    g.setColor(Color.black);
                    g.drawString(String.valueOf(this.ardeg), this.orx - 8 + x * (this.anchox + this.espaciox), this.panel.getHeight() - this.altura_etiqueta_grados);
                    this.ardeg = this.tipo_de_punto_de_vista == ON_THE_EARTH ? (this.ardeg -= 15) : (this.ardeg += 15);
                }
            }
            if (y == 0) {
                ++this.saltox;
                if (this.saltox == 3) {
                    this.saltox = 0;
                    g.setColor(Color.black);
                    this.arhor = this.tipo_de_punto_de_vista == ON_THE_EARTH ? (int)((double)(72 - x) / 3.0) : (int)((double)x / 3.0);
                    g.drawString(String.valueOf(this.arhor), this.orx + x * (this.anchox + this.espaciox), this.ory - this.altura_etiqueta_ar);
                }
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <dibuja_etiquetas>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public void dibuja_cielo(Graphics g, boolean full) {
        Celda c = new Celda();
        float dato_estimacion_relativa = 0.0f;
        float dato_estimacion = 0.0f;
        int ximg = 0;
        for (int y = 35; y >= 0; --y) {
            for (int x = 0; x < 72; ++x) {
                c = this.skscr.get_celda(x, y);
                dato_estimacion = c.estimacion;
                dato_estimacion_relativa = c.estimacion_relativa;
                if (!this.cumple_condicion(c)) {
                    dato_estimacion = 0.0f;
                    dato_estimacion_relativa = 0.0f;
                }
                switch (this.tipo_salida) {
                    case 3: {
                        String color_opaco = this.obtiene_color((int)dato_estimacion);
                        g.setColor(Color.decode(color_opaco));
                        if (!((color_opaco.equals("0xFFFFFF") || color_opaco.equals("0x000000")) & full)) break;
                        Color color = new Color(0, 0, 0, 255);
                        g.setColor(color);
                        break;
                    }
                    case 4: {
                        String color_opaco = this.obtiene_color((int)dato_estimacion_relativa);
                        g.setColor(Color.decode(color_opaco));
                        if (!((color_opaco.equals("0xFFFFFF") || color_opaco.equals("0x000000")) & full)) break;
                        Color color = new Color(0, 0, 0, 255);
                        g.setColor(color);
                        break;
                    }
                }
                if (this.tipo_de_punto_de_vista == BEHIND_THE_STARS) {
                    ximg = x;
                }
                if (this.tipo_de_punto_de_vista == ON_THE_EARTH) {
                    ximg = 71 - x;
                }
                this.proyecciones(ximg, y);
                if (full) {
                    this.prox = ximg * 10;
                    this.proy = (35 - y) * 10;
                    g.fillRect(this.prox, this.proy, 10, 10);
                    continue;
                }
                g.fillRect(this.orx + this.desp_x + this.prox, this.ory + this.proy, this.anchox, this.anchoy);
            }
        }
    }

    public void dibuja(Graphics g) {
        try {
            String aux = "";
            String fechanormal = "";
            FechaHora fn = new FechaHora();
            this.prox = 0;
            this.proy = 0;
            this.orx = 35;
            this.ory = 40;
            this.desp_x = 0;
            this.skscr = this.mskmaps.array_de_Skymaps[this.registro - 1];
            if (this.skscr.usado) {
                this.anchox = (int)((double)(this.panel.getWidth() - this.orx) / 72.0);
                this.anchoy = (int)((double)(this.panel.getHeight() - this.ory - this.altura_etiqueta_grados) / 36.5);
                fechanormal = fn.presenta_AMD(this.skscr.get_hora());
                if (this.yearbox.getText().isEmpty()) {
                    fechanormal = "YYYY" + fechanormal.substring(4, fechanormal.length());
                }
                Justifica jus = new Justifica();
                fechanormal = fechanormal + " " + jus.completa(String.valueOf(this.skscr.get_hora().get(11)), 2) + ":" + jus.completa(String.valueOf(this.skscr.get_hora().get(12)), 2) + ":" + jus.completa(String.valueOf(this.skscr.get_hora().get(13)), 2);
                g.drawString(fechanormal, 10, this.ory - 30);
                if (!this.filename_skm.isEmpty()) {
                    g.drawString("File Name: " + this.filename_skm, 200, this.ory - 30);
                }
                this.ejex = 72 * (this.anchox + this.espaciox);
                this.ejey = 36 * (this.anchoy + this.espacioy);
                this.dibuja_cielo(g, false);
                int ximg = 0;
                this.ardeg = 0;
                if (this.tipo_de_punto_de_vista == ON_THE_EARTH) {
                    this.ardeg = 360;
                }
                this.arhor = 0;
                this.prox = 0;
                this.proy = 0;
                this.marca_horaria = 0;
                this.marca_grados = 0;
                g.setColor(Color.black);
                g.drawString(String.valueOf(90), 10, 18 + this.ory + -1 * (this.anchoy + this.espacioy));
                for (int y = 35; y >= 0; --y) {
                    g.setColor(Color.black);
                    g.drawString(String.valueOf(-90 + y * 5), 10, 18 + this.ory + (35 - y) * (this.anchoy + this.espacioy));
                    this.saltox = 1;
                    ++this.marca_grados;
                    if (this.marca_grados == 4) {
                        this.marca_grados = 1;
                    }
                    for (int x = 0; x < 72; ++x) {
                        if (this.tipo_de_punto_de_vista == BEHIND_THE_STARS) {
                            ximg = x;
                        }
                        if (this.tipo_de_punto_de_vista == ON_THE_EARTH) {
                            ximg = 71 - x;
                        }
                        this.proyecciones(ximg, y);
                        this.dibuja_grid(x, y, g);
                        this.dibuja_etiquetas(x, y, g);
                    }
                }
                if (this.sites) {
                    this.dibuja_sitios(g);
                }
                if (this.streams) {
                    this.dibuja_lluvias(g);
                }
                if (this.stars) {
                    this.dibuja_estrellas(g);
                }
                if (this.constellations) {
                    this.dibuja_constelaciones(g);
                }
            } else {
                g.drawString("NO VALID SKYMAP REGISTER", this.panel.getWidth() / 2 - 100, this.panel.getHeight() / 2);
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <dibuja>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            this.recordinf.repaint();
            this.recordsup.repaint();
            this.record.repaint();
            this.numobs.repaint();
            this.intensity.repaint();
            this.down.repaint();
            this.nivel_color_box.repaint();
            this.up.repaint();
            this.nobs_box.repaint();
            this.output_type_selection_list.repaint();
            this.initdate.repaint();
            this.yearbox.repaint();
            this.mes.repaint();
            this.monthbox.repaint();
            this.dia.repaint();
            this.daybox.repaint();
            this.hora.repaint();
            this.hourbox.repaint();
            this.shift.repaint();
            this.incbox.repaint();
            this.periodo.repaint();
            this.periodbox.repaint();
            this.registrosbox.repaint();
            this.process_button.repaint();
            this.progb.repaint();
            g = this.panel.getGraphics();
            this.dibuja(g);
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <paint>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public void presenta_Skymap_en_grafico() {
        try {
            Array_de_Skymaps msk = new Array_de_Skymaps();
            System.arraycopy(this.mskmaps.array_de_Skymaps, 0, msk.array_de_Skymaps, 0, this.mskmaps.array_de_Skymaps.length);
            this.repaint();
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <presenta_Skymap_en_grafico>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public void presenta_skm(String rutaynombre) throws Exception {
        try {
            Skymap sk = new Skymap();
            this.filename_skm = rutaynombre;
            int c = 0;
            FicheroSkymap fsk = new FicheroSkymap();
            if (fsk.asigna_nombre_lectura(rutaynombre) == 0) {
                while (!fsk.eof()) {
                    sk = fsk.leer_registro();
                    if (fsk.eof() || !sk.usado) continue;
                    this.skscr.set_Skymap(sk);
                    this.mskmaps.array_de_Skymaps[c] = sk;
                    if (c == 0) {
                        this.registro = 1;
                        this.skscr.set_Skymap(this.mskmaps.array_de_Skymaps[this.registro - 1]);
                    }
                    ++c;
                }
                this.presenta_Skymap_en_grafico();
            } else {
                this.ventanalog.log("Class <Pantalla> : Method <presenta_skm>");
                this.ventanalog.log("Problem reading Skymap record " + String.valueOf(c) + " of file : " + fsk.nombre);
            }
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <presenta_skm>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    private ConjuntoDatos obtiene_datos(String cadena) {
        ConjuntoDatos ds = new ConjuntoDatos();
        try {
            StringTokenizer st = new StringTokenizer(cadena);
            String time = st.nextToken(";");
            ds.AR = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.Dec = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.Azimut = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.Elevacion = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.obs = Integer.parseInt(st.nextToken(";"));
            ds.conteo = Integer.parseInt(st.nextToken(";"));
            ds.average = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.relative_count = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.relative_count_average = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.monthly_average = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.monthly_maximum = Integer.parseInt(st.nextToken(";"));
            ds.monthly_minimum = Integer.parseInt(st.nextToken(";"));
            ds.monthly_standard_deviation = Float.valueOf(Float.parseFloat(st.nextToken(";")));
            ds.monthly_number_of_invalid_entries = Integer.parseInt(st.nextToken(";"));
            String valid = st.nextToken(";");
            ds.valid_data = "true".equals(valid);
            return ds;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <obtiene_datos>");
            this.ventanalog.log_tracktrace(e);
            return ds;
        }
    }

    private Skymap pasa_datos_de_fichero_DB_a_skm(String rutaynombre, GregorianCalendar fdat, int intervalo_horas) {
        Skymap sk = new Skymap();
        try {
            ConjuntoDatos cjd = new ConjuntoDatos();
            FicheroTexto ent = new FicheroTexto();
            ent.asigna_nombre_lectura(rutaynombre);
            ent.leer_linea();
            FechaHora fh = new FechaHora();
            GregorianCalendar fini = new GregorianCalendar();
            GregorianCalendar fmax = new GregorianCalendar();
            DatosMarco dm = new DatosMarco();
            dm.genera_fechas_marco(fdat, intervalo_horas);
            fini.setTime(dm.getStart_date().getTime());
            fmax.setTime(dm.getEnd_date().getTime());
            Celda c = new Celda();
            Medidas_de_Dispersion medidas = new Medidas_de_Dispersion();
            int[] offsets = new int[]{0, 0};
            sk.usado = true;
            while (!ent.eof()) {
                String linea = ent.leer_linea();
                if (linea.length() <= 14) continue;
                fh.setTime_from_YYYYMMDDHHMMSS(linea.substring(0, 14));
                if (!(fini.getTimeInMillis() <= fh.getTime().getTimeInMillis() & fh.getTime().getTimeInMillis() < fmax.getTimeInMillis())) continue;
                cjd = this.obtiene_datos(linea);
                medidas.media = cjd.monthly_average.floatValue();
                medidas.maximo = cjd.monthly_maximum;
                medidas.minimo = cjd.monthly_minimum;
                medidas.desviacion_estandard = cjd.monthly_standard_deviation.floatValue();
                medidas.numero_de_entradas_invalidas = cjd.monthly_number_of_invalid_entries;
                medidas.datos_validos = cjd.valid_data;
                c.set_datos(cjd.obs, cjd.conteo, medidas);
                sk.set_square_fooprint_1(cjd.AR.floatValue(), cjd.Dec.floatValue(), offsets[0], offsets[1], c);
            }
            ent.cerrar_fichero_entrada();
            return sk;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <pasa_datos_de_fichero_DB_a_skm>");
            this.ventanalog.log_tracktrace(e);
            sk.usado = false;
            return sk;
        }
    }

    private boolean cumple_condicion_de_proceso(String s, GregorianCalendar fecha, int intervalo_en_horas) {
        try {
            DatosMarco dm = new DatosMarco();
            dm.genera_fechas_marco(fecha, intervalo_en_horas);
            GregorianCalendar fini = new GregorianCalendar();
            GregorianCalendar fmax = new GregorianCalendar();
            fini.setTime(dm.getStart_date().getTime());
            fmax.setTime(dm.getEnd_date().getTime());
            if (s.contains("rmob_DB.txt")) {
                Justifica aux = new Justifica();
                String anyoini = String.valueOf(fini.get(1));
                String anyomax = String.valueOf(fmax.get(1));
                String mes_proc_ini = aux.completa(String.valueOf(fini.get(2) + 1), 2);
                String mes_proc_max = aux.completa(String.valueOf(fmax.get(2) + 1), 2);
                if (!this.yearbox.getText().equals("")) {
                    boolean mesanyocoin = false;
                    mesanyocoin = s.contains(mes_proc_ini + anyoini + "rmob_DB.txt") || s.contains(mes_proc_max + anyomax + "rmob_DB.txt");
                    return mesanyocoin;
                }
                if (this.yearbox.getText().equals("")) {
                    String sub = s.substring(s.length() - 17, s.length());
                    boolean mescoin = false;
                    boolean bl = mescoin = sub.substring(0, 2).equals(mes_proc_ini) || sub.substring(0, 2).equals(mes_proc_max);
                    if (mescoin) {
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <cumple_condicion_de_proceso>");
            this.ventanalog.log_tracktrace(e);
            return false;
        }
    }

    private void elementos_de_la_ventana() {
        try {
            Container contenedor = new Container();
            contenedor.setSize(1000, 600);
            GridBagLayout gbl = new GridBagLayout();
            contenedor.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            this.archivo.setLabel("File");
            this.archivo.add("Process Selected RMOB Files");
            this.archivo.add("Process Directory of DB Files");
            this.archivo.add("Save Skymap File");
            this.archivo.add("Load Skymap File");
            this.archivo.add("Exit");
            this.imagen.setLabel("Image");
            this.imagen.add("Toogle Projection");
            this.imagen.add("Change Point of View");
            this.imagen.add("Toogle Palette");
            this.imagen.add("Toogle Sky Color");
            this.imagen.add("Stars");
            this.imagen.add("Constellations");
            this.imagen.add("Streams");
            this.imagen.add("Grid");
            this.imagen.add("Sites");
            this.imagen.add("Loop");
            this.logm.setLabel("Logging");
            this.logm.add("Log");
            this.logm.add("Skymap Data -> Log");
            this.realT.setLabel("Real Time");
            this.realT.add("Start");
            this.realT.add("Stop");
            this.help.setLabel("Help");
            this.help.add("Program Help");
            this.help.add("About");
            this.menu.add(this.archivo);
            this.menu.add(this.imagen);
            this.menu.add(this.logm);
            this.menu.add(this.realT);
            this.menu.add(this.help);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            gbc.insets.set(5, 5, 5, 5);
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.recordinf.setBackground(SystemColor.control);
            contenedor.add((Component)this.recordinf, gbc);
            gbc.fill = 3;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.anchor = 10;
            this.record.setBackground(SystemColor.control);
            contenedor.add((Component)this.record, gbc);
            gbc.fill = 1;
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.recordsup.setBackground(SystemColor.control);
            contenedor.add((Component)this.recordsup, gbc);
            gbc.fill = 1;
            gbc.gridx = 4;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.numobs.setBackground(SystemColor.control);
            contenedor.add((Component)this.numobs, gbc);
            gbc.fill = 1;
            gbc.gridx = 5;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.nobs_box.setSize(10, 5);
            this.nobs_box.setBackground(Color.white);
            contenedor.add((Component)this.nobs_box, gbc);
            this.nobs_box.setName("nobs_box");
            gbc.fill = 1;
            gbc.gridx = 6;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            this.intensity.setBackground(SystemColor.control);
            contenedor.add((Component)this.intensity, gbc);
            gbc.fill = 13;
            gbc.gridx = 7;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            this.down.setBackground(SystemColor.control);
            contenedor.add((Component)this.down, gbc);
            gbc.fill = 1;
            gbc.gridx = 8;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            this.nivel_color_box.setBackground(Color.white);
            this.nivel_color_box.setEditable(false);
            contenedor.add((Component)this.nivel_color_box, gbc);
            gbc.fill = 17;
            gbc.gridx = 9;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            this.up.setBackground(SystemColor.control);
            contenedor.add((Component)this.up, gbc);
            gbc.fill = 1;
            gbc.gridx = 10;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 4;
            contenedor.add((Component)this.progb, gbc);
            this.output_type_selection_list.add("Estimation");
            this.output_type_selection_list.add("Relative Estimation");
            this.output_type_selection_list.select(1);
            gbc.fill = 1;
            gbc.gridx = 14;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 5;
            this.output_type_selection_list.setBackground(SystemColor.control);
            contenedor.add((Component)this.output_type_selection_list, gbc);
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 19;
            gbc.weighty = 200.0;
            gbc.weightx = 1.0;
            this.panel.setBackground(SystemColor.control);
            this.panel.setBorder(null);
            contenedor.add((Component)this.panel, gbc);
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.initdate.setBackground(SystemColor.control);
            contenedor.add((Component)this.initdate, gbc);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.yearbox.setBackground(Color.white);
            contenedor.add((Component)this.yearbox, gbc);
            this.yearbox.setName("yearbox");
            gbc.fill = 3;
            gbc.gridx = 2;
            gbc.gridy = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            this.mes.setBackground(SystemColor.control);
            contenedor.add((Component)this.mes, gbc);
            Justifica js1 = new Justifica();
            for (int i = 1; i < 13; ++i) {
                this.monthbox.add(js1.completa(String.valueOf(i), 2));
            }
            this.monthbox.select(0);
            gbc.fill = 1;
            gbc.gridx = 3;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.monthbox.setBackground(Color.white);
            contenedor.add((Component)this.monthbox, gbc);
            this.monthbox.setName("monthbox");
            gbc.anchor = 13;
            gbc.fill = 3;
            gbc.gridx = 4;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.dia.setBackground(SystemColor.control);
            contenedor.add((Component)this.dia, gbc);
            Justifica js2 = new Justifica();
            for (int i = 1; i < 32; ++i) {
                this.daybox.add(js2.completa(String.valueOf(i), 2));
            }
            this.daybox.select(0);
            this.daybox.setName("daybox");
            gbc.fill = 1;
            gbc.gridx = 5;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.daybox.setBackground(Color.white);
            contenedor.add((Component)this.daybox, gbc);
            gbc.fill = 3;
            gbc.gridx = 6;
            gbc.gridy = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.hora.setBackground(SystemColor.control);
            contenedor.add((Component)this.hora, gbc);
            gbc.fill = 1;
            gbc.gridx = 7;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            Justifica js3 = new Justifica();
            for (int i = 0; i < 24; ++i) {
                this.hourbox.add(js3.completa(String.valueOf(i), 2));
            }
            this.hourbox.select(0);
            this.hourbox.setBackground(Color.white);
            contenedor.add((Component)this.hourbox, gbc);
            this.hourbox.setName("hourbox");
            gbc.fill = 3;
            gbc.gridx = 8;
            gbc.gridy = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.shift.setBackground(SystemColor.control);
            contenedor.add((Component)this.shift, gbc);
            gbc.fill = 1;
            gbc.gridx = 9;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            contenedor.add((Component)this.incbox, gbc);
            this.incbox.setName("incbox");
            gbc.fill = 3;
            gbc.gridx = 10;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.periodo.setBackground(SystemColor.control);
            contenedor.add((Component)this.periodo, gbc);
            gbc.fill = 1;
            gbc.gridx = 12;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            contenedor.add((Component)this.periodbox, gbc);
            this.periodbox.setName("periodbox");
            gbc.fill = 3;
            gbc.gridx = 14;
            gbc.gridy = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            this.pt.setBackground(SystemColor.control);
            contenedor.add((Component)this.pt, gbc);
            gbc.fill = 1;
            gbc.gridx = 15;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.registrosbox.setBackground(Color.white);
            contenedor.add((Component)this.registrosbox, gbc);
            this.registrosbox.setName("registrosbox");
            gbc.fill = 1;
            gbc.gridx = 17;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.process_button.setBackground(SystemColor.control);
            contenedor.add((Component)this.process_button, gbc);
            this.setBackground(SystemColor.control);
            this.setMenuBar(this.menu);
            this.add(contenedor);
            this.setSize(contenedor.getSize());
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>.");
            this.ventanalog.log("Method: <elementos_de_la_ventana>");
            this.ventanalog.log_tracktrace(e);
        }
    }

    public void actualiza() {
        this.seleccionar_archivos = false;
        this.ProcDir_DB.main();
    }

    private void deshabilita_menu() {
    }

    private void aplicar_image_loop_setting() {
        if (this.image_loop) {
            this.temporizador_image_loop.setDelay(this.interval);
            this.temporizador_image_loop.start();
        } else {
            this.temporizador_image_loop.stop();
        }
    }

    private void procesa_Ficheros_RMOB(boolean b) {
        Procesa_Ficheros_RMOB map_file_process = new Procesa_Ficheros_RMOB(true);
        map_file_process.main(b);
    }

    private void toogle_image_loop_setting() {
        this.image_loop = !this.image_loop;
        this.aplicar_image_loop_setting();
    }

    @Override
    public boolean handleEvent(Event evento) {
        try {
            String elemdato;
            String elemname;
            StringTokenizer ele;
            switch (evento.id) {
                case 201: {
                    this.dispose();
                    System.exit(0);
                }
            }
            Object argumento = evento.arg;
            Object elemento = evento.target;
            int tecla = evento.key;
            int inicio_nombre_elemento = elemento.toString().indexOf("[") + 1;
            String nombre = "";
            if (argumento != null) {
                // empty if block
            }
            if (elemento != null) {
                // empty if block
            }
            if (elemento instanceof TextField) {
                ele = new StringTokenizer(elemento.toString().substring(inicio_nombre_elemento), ",");
                elemname = ele.nextToken();
                elemdato = ele.nextToken();
                elemdato = ele.nextToken();
                elemdato = ele.nextToken();
                elemdato = ele.nextToken();
                if ("nobs_box".equals(elemname) & tecla == 10) {
                    this.repaint();
                }
                if ("yearbox".equals(elemname) & tecla == 10) {
                    this.actualiza();
                }
                if ("periodbox".equals(elemname) & tecla == 10) {
                    this.actualiza();
                }
                if ("registrosbox".equals(elemname) & tecla == 10) {
                    this.actualiza();
                }
            }
            if (elemento instanceof Button) {
                String aux;
                nombre = (String)argumento;
                if ("Proc".equals(nombre)) {
                    this.actualiza();
                    this.setFileName("");
                }
                if ("->".equals(nombre)) {
                    this.registro_siguiente();
                }
                if ("<-".equals(nombre)) {
                    this.registro_anterior();
                }
                if ("Up".equals(nombre)) {
                    this.nivel_color += 0.1f;
                    aux = String.valueOf(this.nivel_color);
                    this.nivel_color_box.setText(aux.substring(0, this.minimo(5, aux.length())));
                    this.repaint();
                }
                if ("Down".equals(nombre)) {
                    this.nivel_color -= 0.1f;
                    if (this.nivel_color < 0.0f) {
                        this.nivel_color = 0.0f;
                    }
                    aux = String.valueOf(this.nivel_color);
                    this.nivel_color_box.setText(aux.substring(0, this.minimo(5, aux.length())));
                    this.repaint();
                }
            }
            if (elemento instanceof MenuItem) {
                FicheroSkymap fsk;
                nombre = (String)argumento;
                if ("Process Selected RMOB Files".equals(nombre)) {
                    this.comprueba_cambio_de_dia();
                    this.ventanalog.log("Process Selected RMOB Files");
                    RaMAP.last_directory_rmob = this.last_directory_rmob;
                    RaMAP.last_directory_db = this.last_directory_db;
                    this.ventanalog.log("Last RMOB directory: " + RaMAP.last_directory_rmob);
                    this.procesa_Ficheros_RMOB(true);
                }
                if ("Process Directory of DB Files".equals(nombre)) {
                    this.comprueba_cambio_de_dia();
                    this.lluvias.carga_archivo_corrientes_meteoricas(this.nombre_fic_corrientes);
                    this.sitios.carga_archivo_de_localizaciones(this.nombre_fic_lugares);
                    this.seleccionar_archivos = true;
                    RaMAP.last_directory_db = this.last_directory_db;
                    procesa_directorio_DB pd = new procesa_directorio_DB();
                    pd.main();
                }
                if ("Load Skymap File".equals(nombre)) {
                    this.comprueba_cambio_de_dia();
                    this.lluvias.carga_archivo_corrientes_meteoricas(this.nombre_fic_corrientes);
                    this.sitios.carga_archivo_de_localizaciones(this.nombre_fic_lugares);
                    fsk = new FicheroSkymap();
                    RaMAP.last_directory_skm = this.last_directory_skm;
                    fsk.ruta = this.last_directory_skm;
                    fsk.seleccionar_fichero();
                    this.ventanalog.log_depuracion(fsk.ruta + fsk.nombre);
                    fsk.asigna_nombre_lectura(fsk.ruta + fsk.nombre);
                    int i = 0;
                    while (!fsk.eof()) {
                        this.last_skymap = i;
                        this.mskmaps.array_de_Skymaps[i].set_Skymap(fsk.leer_registro());
                        ++i;
                    }
                    this.registro = 1;
                    this.repaint();
                    this.setFileName(fsk.nombre);
                    this.last_directory_skm = fsk.ruta;
                }
                if ("Save Skymap File".equals(nombre)) {
                    this.comprueba_cambio_de_dia();
                    fsk = new FicheroSkymap();
                    if (!"".equals(this.last_directory_skm)) {
                        fsk.ruta = this.last_directory_skm;
                    }
                    if (!fsk.seleccionar_fichero_salida().equals("")) {
                        this.last_directory_skm = fsk.ruta;
                        this.ventanalog.log_depuracion(fsk.ruta + fsk.nombre);
                        int i = 0;
                        fsk.asigna_nombre_escritura(fsk.ruta + fsk.nombre);
                        while (this.mskmaps.array_de_Skymaps[i].usado) {
                            fsk.escribir_Skymap(this.mskmaps.array_de_Skymaps[i]);
                            ++i;
                        }
                        fsk.cerrar_fichero();
                    }
                }
                if ("Exit".equals(nombre)) {
                    this.dispose();
                    System.exit(0);
                }
                if ("Toogle Sky Color".equals(nombre)) {
                    this.color_del_cielo = this.color_del_cielo == SKY_BLACK ? SKY_WHITE : SKY_BLACK;
                }
                if ("Change Point of View".equals(nombre)) {
                    this.change_point_of_view();
                }
                if ("Toogle Projection".equals(nombre)) {
                    this.change_projection();
                }
                if ("Toogle Palette".equals(nombre)) {
                    this.change_palette();
                }
                if ("Grid".equals(nombre)) {
                    this.grid = !this.grid;
                    this.repaint();
                }
                if ("Streams".equals(nombre)) {
                    this.streams = !this.streams;
                }
                if ("Stars".equals(nombre)) {
                    this.stars = !this.stars;
                }
                if ("Constellations".equals(nombre)) {
                    this.constellations = !this.constellations;
                }
                if ("Sites".equals(nombre)) {
                    this.sites = !this.sites;
                }
                if ("Loop".equals(nombre)) {
                    this.toogle_image_loop_setting();
                }
                if ("Log".equals(nombre)) {
                    this.ventanalog.setVisible(true);
                }
                if ("Skymap Data -> Log".equals(nombre)) {
                    this.ventanalog.log("----------------------------------------------------------------");
                    this.ventanalog.log("-----------------------------Skymap-----------------------------");
                    this.ventanalog.log("----------------------------------------------------------------");
                    this.presenta_mapa_en_texto(this.skscr, 1);
                    this.ventanalog.log("");
                    this.presenta_mapa_en_texto(this.skscr, 2);
                    this.ventanalog.log("");
                    this.presenta_mapa_en_texto(this.skscr, 3);
                    this.ventanalog.log("");
                    this.presenta_mapa_en_texto(this.skscr, 4);
                    this.ventanalog.log("");
                    this.ventanalog.setVisible(true);
                }
                if ("Program Help".equals(nombre)) {
                    Help hlp = new Help();
                }
                if ("About".equals(nombre)) {
                    AcercaDe acerca = new AcercaDe();
                }
                if ("Start".equals(nombre) && RaMAP.program_status == 0) {
                    RaMAP.program_status = 1;
                    RaMAP.last_realtime_directory_db = this.rlt_directory_db;
                    RaMAP.last_realtime_directory_rmob = this.rlt_directory_rmob;
                    RaMAP.last_realtime_directory_skm = this.rlt_directory_skm;
                    this.filename_skm = "";
                    this.lluvias.carga_archivo_corrientes_meteoricas(this.nombre_fic_corrientes);
                    this.sitios.carga_archivo_de_localizaciones(this.nombre_fic_lugares);
                    this.realtime.run();
                    this.temporizador_proceso_en_tiempo_real.start();
                    this.archivo.setEnabled(false);
                }
                if ("Stop".equals(nombre)) {
                    this.temporizador_proceso_en_tiempo_real.stop();
                    this.realtime.temporizador_procesa_archivos_DB.stop();
                    this.realtime.temporizador_salva_imagen.stop();
                    this.archivo.setEnabled(true);
                    RaMAP.program_status = 0;
                }
            }
            if (elemento instanceof TextArea) {
                // empty if block
            }
            if (elemento instanceof JRadioButton && "Grid".equals(nombre = (String)argumento)) {
                this.repaint();
            }
            if (elemento instanceof Choice) {
                ele = new StringTokenizer(elemento.toString().substring(inicio_nombre_elemento), ",");
                elemname = ele.nextToken();
                elemdato = ele.nextToken();
                elemdato = ele.nextToken();
                elemdato = ele.nextToken();
                elemdato = ele.nextToken();
                nombre = (String)argumento;
                if ("Relative Estimation".equals(nombre)) {
                    this.tipo_salida = this.output_type_selection_list.getSelectedIndex() + 3;
                    this.repaint();
                }
                if ("Estimation".equals(nombre)) {
                    this.tipo_salida = this.output_type_selection_list.getSelectedIndex() + 3;
                    this.repaint();
                }
            }
            return true;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>");
            this.ventanalog.log("Method: handleEvent()");
            this.ventanalog.log_tracktrace(e);
            return false;
        }
    }

    private void log_incorrect_path(String path_name, String path_obtained) {
        this.ventanalog.log(path_name + path_obtained);
        this.ventanalog.log("Is not considered valid. Please check directory string. Characters below Blank Space,or containing < > : '' | ? *, are not considered valid");
    }

    private int carga_archivo_de_configuracion() {
        int resultado = 0;
        FicheroTexto fcfg = new FicheroTexto();
        try {
            this.ventanalog.log("-------------------------------------");
            this.ventanalog.log("Config file name: " + this.nombre_fic_config);
            fcfg.asigna_nombre_lectura(this.nombre_fic_config);
            String linea = "";
            String directorio = "";
            while (!fcfg.eof()) {
                Object aux;
                linea = fcfg.leer_linea();
                if (linea.contains("realtime_rmob_directory=")) {
                    Cadena dir_rmob;
                    aux = linea.substring(24, linea.length());
                    if (((String)aux).charAt(0) == '.') {
                        aux = this.ruta_de_la_aplicacion + ((String)aux).substring(1);
                    }
                    if ((dir_rmob = new Cadena((String)aux)).isCorrectDirFileName()) {
                        RaMAP.last_realtime_directory_rmob = this.rlt_directory_rmob = dir_rmob.getCadena();
                        this.ventanalog.log("Realtime RMOB directory: " + this.rlt_directory_rmob);
                    } else {
                        resultado = 1;
                        this.log_incorrect_path("The RMOB Realtime Directory: ", dir_rmob.getCadena());
                    }
                }
                if (linea.contains("realtime_db_directory=")) {
                    Cadena dir_dat;
                    aux = linea.substring(22, linea.length());
                    if (((String)aux).charAt(0) == '.') {
                        aux = this.ruta_de_la_aplicacion + ((String)aux).substring(1);
                    }
                    if ((dir_dat = new Cadena((String)aux)).isCorrectDirFileName()) {
                        RaMAP.last_realtime_directory_db = this.rlt_directory_db = dir_dat.getCadena();
                        this.ventanalog.log("Realtime DB directory: " + this.rlt_directory_db);
                    } else {
                        resultado = 1;
                        this.log_incorrect_path("The DataBase Realtime Directory: ", dir_dat.getCadena());
                    }
                }
                if (linea.contains("realtime_image_directory=")) {
                    Cadena dir_img;
                    aux = linea.substring(25, linea.length());
                    if (((String)aux).charAt(0) == '.') {
                        aux = this.ruta_de_la_aplicacion + ((String)aux).substring(1);
                    }
                    if ((dir_img = new Cadena((String)aux)).isCorrectDirFileName()) {
                        this.rlt_directory_current_image = dir_img.getCadena();
                    } else {
                        resultado = 1;
                        this.log_incorrect_path("The Image Realtime Directory: ", dir_img.getCadena());
                    }
                }
                if (linea.contains("realtime_skm_directory=")) {
                    Cadena dir_skm;
                    aux = linea.substring(23, linea.length());
                    if (((String)aux).charAt(0) == '.') {
                        aux = this.ruta_de_la_aplicacion + ((String)aux).substring(1);
                    }
                    if ((dir_skm = new Cadena((String)aux)).isCorrectDirFileName()) {
                        RaMAP.last_realtime_directory_skm = this.rlt_directory_skm = dir_skm.getCadena();
                        this.ventanalog.log("Realtime SKM directory: " + this.rlt_directory_skm);
                    } else {
                        resultado = 1;
                        this.log_incorrect_path("The SKM Realtime Directory: ", dir_skm.getCadena());
                    }
                }
                if (linea.contains("realtime_overlay_directory=")) {
                    Cadena dir_ovl;
                    aux = linea.substring(27, linea.length());
                    if (((String)aux).charAt(0) == '.') {
                        aux = this.ruta_de_la_aplicacion + ((String)aux).substring(1);
                    }
                    if ((dir_ovl = new Cadena((String)aux)).isCorrectDirFileName()) {
                        this.rlt_directory_overlay = dir_ovl.getCadena();
                    } else {
                        resultado = 1;
                        this.log_incorrect_path("The SKM Realtime Directory: ", dir_ovl.getCadena());
                    }
                }
                if (linea.contains("realtime_rmob_data_source=")) {
                    Cadena rmob_source = new Cadena(linea.substring(26, linea.length()));
                    if (rmob_source.isCorrectDirFileName()) {
                        this.rmob_data_source = rmob_source.getCadena();
                    } else {
                        resultado = 1;
                        this.log_incorrect_path("The RMOB Data Source: ", rmob_source.getCadena());
                    }
                }
                if (linea.contains("loop=")) {
                    aux = linea.substring(5, linea.length());
                    if (((String)aux).equals("true")) {
                        this.image_loop = true;
                        this.ventanalog.log("Image loop activated");
                    } else {
                        this.image_loop = false;
                        this.ventanalog.log("The value for 'image_loop' is set to FALSE.");
                    }
                    this.aplicar_image_loop_setting();
                }
                if (linea.contains("interval=")) {
                    aux = new Cadena(linea.substring(9, linea.length()));
                    if (((Cadena)aux).isIntNumber()) {
                        this.interval = Integer.parseInt(((Cadena)aux).getCadena());
                        this.ventanalog.log("Interval for the image loop: " + this.interval);
                    } else {
                        this.interval = 1000;
                        this.ventanalog.log("The value for 'interval' in the configuration file is not an integer number. The value 1000 has been set by default.");
                    }
                }
                if (linea.contains("shift=")) {
                    aux = new Cadena(linea.substring(6, linea.length()));
                    if (((Cadena)aux).isIntNumber()) {
                        this.incbox.setText(((Cadena)aux).getCadena());
                        this.ventanalog.log("Shift: " + ((Cadena)aux).getCadena());
                    } else {
                        this.incbox.setText("1");
                        this.ventanalog.log("The value for 'shift' in the configuration file is not an integer number. The value 1 has been set by default.");
                    }
                }
                if (linea.contains("period=")) {
                    aux = new Cadena(linea.substring(7, linea.length()));
                    if (((Cadena)aux).isIntNumber()) {
                        this.periodbox.setText(((Cadena)aux).getCadena());
                        this.ventanalog.log("Period: " + ((Cadena)aux).getCadena());
                    } else {
                        this.periodbox.setText("-4");
                        this.ventanalog.log("The value for 'period' in the configuration file is not an integer number. The value -4 has been set by default.");
                    }
                }
                if (linea.contains("records=")) {
                    aux = new Cadena(linea.substring(8, linea.length()));
                    if (((Cadena)aux).isIntNumber()) {
                        this.registrosbox.setText(((Cadena)aux).getCadena());
                        this.ventanalog.log("Records: " + ((Cadena)aux).getCadena());
                    } else {
                        this.periodbox.setText("24");
                        this.ventanalog.log("The value for 'records' in the configuration file is not an integer number. The value 24 has been set by default.");
                    }
                }
                if (linea.contains("utc_diff=")) {
                    aux = new Cadena(linea.substring(9, linea.length()));
                    if (((Cadena)aux).isIntNumber()) {
                        this.utc_diff = Integer.parseInt(((Cadena)aux).getCadena());
                        this.ventanalog.log("UTC Diff: " + ((Cadena)aux).getCadena());
                    } else {
                        this.utc_diff = 0;
                        this.ventanalog.log("The value for 'utc_diff' in the configuration file is not an integer number. The value 0 has been set by default.");
                    }
                }
                if (this.rlt_directory_rmob.equals("rmb") || this.rlt_directory_rmob.equals("")) {
                    RaMAP.last_realtime_directory_rmob = this.rlt_directory_rmob = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "rlt" + System.getProperty("file.separator") + "rmb" + System.getProperty("file.separator");
                }
                if (this.rlt_directory_db.equals("dat") || this.rlt_directory_db.equals("")) {
                    RaMAP.last_realtime_directory_db = this.rlt_directory_db = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "rlt" + System.getProperty("file.separator") + "dat" + System.getProperty("file.separator");
                }
                if (this.rlt_directory_current_image.equals("img") || this.rlt_directory_current_image.equals("")) {
                    this.rlt_directory_current_image = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "rlt" + System.getProperty("file.separator") + "img" + System.getProperty("file.separator");
                }
                if (this.rlt_directory_skm.equals("skm") || this.rlt_directory_skm.equals("")) {
                    RaMAP.last_realtime_directory_skm = this.rlt_directory_skm = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "rlt" + System.getProperty("file.separator") + "skm" + System.getProperty("file.separator");
                }
                if (!this.rlt_directory_overlay.equals("ovl") && !this.rlt_directory_overlay.equals("")) continue;
                this.rlt_directory_overlay = this.ruta_de_la_aplicacion + System.getProperty("file.separator") + "rlt" + System.getProperty("file.separator") + "ovl" + System.getProperty("file.separator");
            }
            fcfg.cerrar_fichero_entrada();
            this.ventanalog.log("-------------------------------------");
            return resultado;
        }
        catch (Exception e) {
            this.ventanalog.log("EXCEPTION: Class: <Pantalla>");
            this.ventanalog.log("Method: carga_archivo_de_configuracion()");
            this.ventanalog.log_tracktrace(e);
            return 1;
        }
    }

    public BufferedImage JPaneltoImage(JPanel panel) {
        int w = panel.getWidth();
        int h = panel.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        panel.print(g);
        this.dibuja(g);
        g.dispose();
        return bi;
    }

    public BufferedImage CielotoImage(JPanel panel) {
        int w = panel.getWidth();
        int h = panel.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 6);
        Graphics2D g = bi.createGraphics();
        panel.print(g);
        this.dibuja_cielo(g, true);
        g.dispose();
        return bi;
    }

    private class procesa_directorio_DB
    implements Runnable {
        static final int MAX_NUM_DB_FILES = 1000;
        private Nombre_de_Fichero_DB[] array_de_archivos_DB = new Nombre_de_Fichero_DB[1000];
        private String[] array_de_nombres_de_archivo_DB_tmp = new String[1000];
        private FicheroTexto filesDB = new FicheroTexto();

        public procesa_directorio_DB() {
            RaMAP.DB_Files_Process_End = false;
            for (int i = 0; i < 1000; ++i) {
                this.array_de_archivos_DB[i] = new Nombre_de_Fichero_DB();
            }
        }

        private void carga_observadores_en_variable_temporal() {
            Pantalla.this.ventanalog.log("Loading names from DB_Files.cfg file in tmp variable.");
            String rutaynombre = "";
            rutaynombre = Pantalla.this.ruta_de_la_aplicacion + Pantalla.this.separador + "cfg" + Pantalla.this.separador + "DB_Files.cfg";
            Pantalla.this.ventanalog.log("From: " + rutaynombre);
            FicheroTexto ft = new FicheroTexto();
            try {
                ft.asigna_nombre_lectura(rutaynombre);
                String linea = "";
                int i = 0;
                while (!ft.eof() & i < 1000) {
                    linea = ft.leer_linea();
                    Pantalla.this.ventanalog.log_depuracion(linea);
                    if (linea.isEmpty() || linea.charAt(0) == '#') continue;
                    this.array_de_nombres_de_archivo_DB_tmp[i] = linea;
                    ++i;
                }
                if (i == 1000) {
                    Pantalla.this.ventanalog.log("WARNING: MAXIMUM NUMBER OF DB FILES REACHED.");
                    Pantalla.this.ventanalog.log("Maximum number of DB files is: " + String.valueOf(1000));
                    Pantalla.this.ventanalog.log("Some DB files could not be processed.");
                }
                Pantalla.this.ventanalog.log("File names loaded.");
            }
            catch (Exception e) {
                Pantalla.this.ventanalog.log("EXCEPTION: Class: <procesa_directorio_DB>.");
                Pantalla.this.ventanalog.log("Method: <carga_observadores_en_variable_temporal()>");
                Pantalla.this.ventanalog.log_tracktrace(e);
                Pantalla.this.ventanalog.log("'DB_Files.cfg' file could not be load.");
            }
        }

        private void crear_cfg_con_nombres_de_archivos_DB() {
            Pantalla.this.ventanalog.log("Creating DB_Files.cfg file");
            String rutaynombre = "";
            rutaynombre = Pantalla.this.ruta_de_la_aplicacion + Pantalla.this.separador + "cfg" + Pantalla.this.separador + "DB_Files.cfg";
            FicheroTexto ft = new FicheroTexto();
            String linea = "";
            try {
                ft.asigna_nombre_escritura(rutaynombre);
                linea = "#Valid(1:Yes / 0:No);File Name";
                ft.escribir_linea(linea);
                for (int i = 0; i < this.filesDB.ficheros.length; ++i) {
                    linea = "1;" + this.filesDB.ficheros[i];
                    ft.escribir_linea(linea);
                }
                ft.cerrar_fichero_salida();
                Pantalla.this.ventanalog.log("DB_Files.cfg file created.");
            }
            catch (Exception e) {
                Pantalla.this.ventanalog.log("EXCEPTION: Class: <procesa_directorio_DB>.");
                Pantalla.this.ventanalog.log("Method: <crear_cfg_con_nombres_de_archivos_DB()>");
                Pantalla.this.ventanalog.log_tracktrace(e);
            }
        }

        private boolean existe_cfg_con_nombres_de_archivos_DB() {
            String rutaynombre = "";
            rutaynombre = Pantalla.this.ruta_de_la_aplicacion + Pantalla.this.separador + "cfg" + Pantalla.this.separador + "DB_Files.cfg";
            FicheroTexto ft = new FicheroTexto();
            try {
                ft.asigna_nombre_lectura(rutaynombre);
                String linea = ft.leer_linea();
                ft.cerrar_fichero_entrada();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private void limpia_lista_DB_files() {
            for (int i = 0; i < 1000; ++i) {
                this.array_de_archivos_DB[i].setName("");
                this.array_de_archivos_DB[i].setValid(false);
            }
        }

        private void carga_nombres_de_archivos_DB() {
            Pantalla.this.ventanalog.log("Loading names from DB_Files.cfg file");
            String rutaynombre = "";
            rutaynombre = Pantalla.this.ruta_de_la_aplicacion + Pantalla.this.separador + "cfg" + Pantalla.this.separador + "DB_Files.cfg";
            Pantalla.this.ventanalog.log("From: " + rutaynombre);
            FicheroTexto ft = new FicheroTexto();
            try {
                ft.asigna_nombre_lectura(rutaynombre);
                String linea = "";
                int i = 0;
                this.limpia_lista_DB_files();
                while (!ft.eof() & i < 1000) {
                    linea = ft.leer_linea();
                    Pantalla.this.ventanalog.log_depuracion(linea);
                    if (linea.isEmpty() || linea.charAt(0) == '#') continue;
                    StringTokenizer st = new StringTokenizer(linea);
                    String valido = st.nextToken(";");
                    String nombre = st.nextToken(";");
                    Pantalla.this.ventanalog.log_depuracion("Setting name and validation of: " + nombre);
                    this.array_de_archivos_DB[i].setName(nombre);
                    if (valido.equals("1")) {
                        this.array_de_archivos_DB[i].setValid(true);
                    } else {
                        this.array_de_archivos_DB[i].setValid(false);
                    }
                    ++i;
                }
                Pantalla.this.ventanalog.log(String.valueOf(i) + " files loaded.");
                if (i >= 1000) {
                    Pantalla.this.ventanalog.log("WARNING: MAXIMUM NUMBER OF DB FILES REACHED.");
                    Pantalla.this.ventanalog.log("Likely all possible files could not be processed.");
                }
            }
            catch (Exception e) {
                Pantalla.this.ventanalog.log("EXCEPTION: Class: <procesa_directorio_DB>.");
                Pantalla.this.ventanalog.log("Method: <carga_nombres_de_archivos_DB()>");
                Pantalla.this.ventanalog.log_tracktrace(e);
                Pantalla.this.ventanalog.log("'DB_Files.cfg' file could not be loaded.");
            }
        }

        private void carga_nombres_de_archivos_DB_comparando() {
            Pantalla.this.ventanalog.log("Comparing observers on the web vs cfg file.");
            String rutaynombre_tmp = "";
            rutaynombre_tmp = Pantalla.this.ruta_de_la_aplicacion + Pantalla.this.separador + "cfg" + Pantalla.this.separador + "DB_Files.tmp";
            FicheroTexto ft1 = new FicheroTexto();
            String linea = "";
            try {
                ft1.asigna_nombre_escritura(rutaynombre_tmp);
                linea = "#Valid(1:Yes / 0:No);File Name";
                ft1.escribir_linea(linea);
                boolean encontrado = false;
                int marca = 0;
                int l = 0;
                Pantalla.this.ventanalog.log("Number of DB files to check: " + this.filesDB.ficheros.length);
                for (int k = 0; k < this.filesDB.ficheros.length; ++k) {
                    l = 0;
                    encontrado = false;
                    while (l < 1000 & l < this.array_de_nombres_de_archivo_DB_tmp.length & this.array_de_nombres_de_archivo_DB_tmp[l] != null & !encontrado) {
                        if (this.array_de_nombres_de_archivo_DB_tmp[l].contains(this.filesDB.ficheros[k])) {
                            encontrado = true;
                            marca = l;
                            Pantalla.this.ventanalog.log_depuracion("File:" + this.filesDB.ficheros[k] + " found");
                        }
                        ++l;
                    }
                    if (encontrado) {
                        linea = this.array_de_nombres_de_archivo_DB_tmp[marca];
                    } else {
                        linea = "1;" + this.filesDB.ficheros[k];
                        Pantalla.this.ventanalog.log("New file " + this.filesDB.ficheros[k] + " added.");
                    }
                    Pantalla.this.ventanalog.log_depuracion("Linea to be included: " + linea);
                    ft1.escribir_linea(linea);
                }
                if (this.filesDB.ficheros.length > 1000) {
                    Pantalla.this.ventanalog.log("WARNING: MAXIMUM NUMBER OF DB FILES REACHED.");
                }
                ft1.cerrar_fichero_salida();
                Pantalla.this.ventanalog.log("Comparison done.");
                String rutaynombre = "";
                rutaynombre = Pantalla.this.ruta_de_la_aplicacion + Pantalla.this.separador + "cfg" + Pantalla.this.separador + "DB_Files.cfg";
                File f1 = new File(rutaynombre);
                f1.delete();
                File f2 = new File(rutaynombre_tmp);
                f2.renameTo(f1);
                Pantalla.this.ventanalog.log("Loading names from DB_Files.cfg file");
                Pantalla.this.ventanalog.log("From: " + rutaynombre);
                FicheroTexto ft = new FicheroTexto();
                ft.asigna_nombre_lectura(rutaynombre);
                linea = "";
                int i = 0;
                this.limpia_lista_DB_files();
                while (!ft.eof() & i < 1000) {
                    linea = ft.leer_linea();
                    Pantalla.this.ventanalog.log_depuracion(linea);
                    if (linea.isEmpty() || linea.charAt(0) == '#') continue;
                    StringTokenizer st = new StringTokenizer(linea);
                    String valido = st.nextToken(";");
                    String nombre = st.nextToken(";");
                    Pantalla.this.ventanalog.log_depuracion("Setting name and validation of: " + nombre);
                    this.array_de_archivos_DB[i].setName(nombre);
                    if (valido.equals("1")) {
                        this.array_de_archivos_DB[i].setValid(true);
                    } else {
                        this.array_de_archivos_DB[i].setValid(false);
                    }
                    ++i;
                }
                if (i == 1000) {
                    Pantalla.this.ventanalog.log("WARNING: MAXIMUM NUMBER OF DB FILES REACHED.");
                }
                Pantalla.this.ventanalog.log("Names from DB_Files.cfg file loaded.");
            }
            catch (Exception e) {
                Pantalla.this.ventanalog.log("EXCEPTION: Class: <procesa_directorio_DB>.");
                Pantalla.this.ventanalog.log("Method: <carga_nombres_de_archivos_DB_comparando()>");
                Pantalla.this.ventanalog.log_tracktrace(e);
                Pantalla.this.ventanalog.log("'DB_Files.cfg' file could not be load.");
            }
        }

        private boolean ValidFileInList(String nombre) {
            int i = 0;
            boolean aux = false;
            boolean encontrado = false;
            while (i < 1000 & !encontrado) {
                if (i < 1000 && this.array_de_archivos_DB[i].getName().equals(nombre)) {
                    encontrado = true;
                    if (this.array_de_archivos_DB[i].isValid()) {
                        aux = true;
                    }
                }
                ++i;
            }
            return aux;
        }

        private void ProcesaDirectorio_DB() {
            Pantalla.this.ventanalog.log("--------------------------------------------------");
            Pantalla.this.ventanalog.log("<ProcesaDirectorio_DB> process begins");
            try {
                Array_de_Skymaps askm = new Array_de_Skymaps();
                int i = 0;
                int contador_total = 0;
                if (RaMAP.program_status == 0) {
                    Pantalla.this.ventanalog.log_depuracion("[ProcesaDirectorio_DB]: Process of DB files in OFF_LINE mode.");
                    if (!RaMAP.last_directory_db.isEmpty()) {
                        Pantalla.this.ventanalog.log_depuracion("[ProcesaDirectorio_DB]: Last directory DB exists.");
                        this.filesDB.ruta = RaMAP.last_directory_db;
                        Pantalla.this.ventanalog.log("[ProcesaDirectorio_DB]: Path of DB Files: " + this.filesDB.ruta);
                    }
                }
                if (RaMAP.program_status == 1) {
                    Pantalla.this.ventanalog.log_depuracion("[pb_DB]: Process of DB files in REAL_TIME mode.");
                    if (!RaMAP.last_realtime_directory_db.isEmpty()) {
                        Pantalla.this.ventanalog.log_depuracion("[ProcesaDirectorio_DB]: Last realtime directory DB exists.");
                        this.filesDB.ruta = RaMAP.last_realtime_directory_db;
                        Pantalla.this.ventanalog.log("[ProcesaDirectorio_DB]: Path of DB Files: " + this.filesDB.ruta);
                    }
                }
                if (Pantalla.this.seleccionar_archivos) {
                    this.filesDB.ficheros = null;
                    Pantalla.this.ventanalog.log_depuracion("[ProcesaDirectorio_DB]: Select File option enabled.");
                    this.filesDB.seleccionar_fichero();
                    Pantalla.this.ventanalog.log_depuracion("Selected Path: " + this.filesDB.ruta);
                    this.filesDB.ficheros = this.filesDB.dir.list();
                } else {
                    Pantalla.this.ventanalog.log_depuracion("[ProcesaDirectorio_DB]: Select File option disable.");
                    this.filesDB.dir = new File(this.filesDB.ruta);
                    this.filesDB.ficheros = this.filesDB.dir.list();
                    Pantalla.this.ventanalog.log("[ProcesaDirectorio_DB]: Number of files: " + this.filesDB.ficheros.length);
                }
                if (this.filesDB.ficheros != null) {
                    Pantalla.this.ventanalog.log("[ProcesaDirectorio_DB]: Number of DB files: " + this.filesDB.ficheros.length);
                    if (RaMAP.program_status == 0) {
                        RaMAP.last_directory_db = this.filesDB.ruta;
                        Pantalla.this.last_directory_db = this.filesDB.ruta;
                    } else {
                        RaMAP.last_realtime_directory_db = this.filesDB.ruta;
                    }
                    GregorianCalendar fini = new GregorianCalendar();
                    fini.set(2000, Pantalla.this.monthbox.getSelectedIndex(), Integer.parseInt(Pantalla.this.daybox.getSelectedItem()), Integer.parseInt(Pantalla.this.hourbox.getSelectedItem()), 0, 0);
                    if (!Pantalla.this.yearbox.getText().equals("")) {
                        Cadena anyo = new Cadena(Pantalla.this.yearbox.getText());
                        if (anyo.isIntNumber()) {
                            fini.set(1, Integer.parseInt(Pantalla.this.yearbox.getText()));
                            Pantalla.this.yearbox.setBackground(Color.white);
                        } else {
                            Pantalla.this.mb.SetMessage("The 'Year' should be an integer number.\nProcess not done.");
                            Pantalla.this.yearbox.setBackground(Color.red);
                            return;
                        }
                    }
                    Cadena shift = new Cadena(Pantalla.this.incbox.getText());
                    int incremento = 1;
                    Pantalla.this.incbox.setBackground(Color.white);
                    if (!Pantalla.this.incbox.getText().equals("") & shift.isIntNumber()) {
                        incremento = Integer.parseInt(Pantalla.this.incbox.getText());
                        Pantalla.this.incbox.setBackground(Color.white);
                        if (incremento < 1 || incremento > 24) {
                            Pantalla.this.mb.SetMessage("'Shift' should be a positive integer number\nwithin 1 to 24, both included.");
                            Pantalla.this.incbox.setBackground(Color.red);
                            return;
                        }
                    } else {
                        Pantalla.this.mb.SetMessage("'Shift' should be an integer number.\nProcess not done.");
                        Pantalla.this.incbox.setBackground(Color.red);
                        return;
                    }
                    Cadena rb = new Cadena(Pantalla.this.registrosbox.getText().trim());
                    int records = 0;
                    boolean proc = false;
                    if (!Pantalla.this.registrosbox.getText().equals("") & rb.isIntNumber() && Integer.parseInt(Pantalla.this.registrosbox.getText().trim()) >= 1 & Integer.parseInt(Pantalla.this.registrosbox.getText().trim()) <= 120) {
                        records = Integer.parseInt(Pantalla.this.registrosbox.getText().trim());
                        Pantalla.this.registrosbox.setBackground(Color.white);
                        proc = true;
                    }
                    if (!proc) {
                        Pantalla.this.mb.SetMessage("The number of 'Records' to process, should be\nan integer number.\nThe value should set between 1 and " + String.valueOf(120) + ".\n" + "Process not done.");
                        Pantalla.this.registrosbox.setBackground(Color.red);
                        return;
                    }
                    Cadena pb = new Cadena(Pantalla.this.periodbox.getText());
                    GregorianCalendar fref = new GregorianCalendar();
                    int periodo = 0;
                    if (!Pantalla.this.periodbox.getText().equals("") & pb.isIntNumber()) {
                        periodo = Integer.parseInt(Pantalla.this.periodbox.getText());
                        Pantalla.this.periodbox.setBackground(Color.white);
                        if (periodo < 0) {
                            fref.setTime(fini.getTime());
                            fini.add(10, -1 * incremento * records);
                        }
                    } else {
                        Pantalla.this.mb.SetMessage("'Period' should be an integer number.\nProcess not done.");
                        Pantalla.this.periodbox.setBackground(Color.red);
                        return;
                    }
                    if (RaMAP.program_status == 1) {
                        if (!this.existe_cfg_con_nombres_de_archivos_DB()) {
                            this.crear_cfg_con_nombres_de_archivos_DB();
                            this.carga_nombres_de_archivos_DB();
                        } else {
                            this.carga_observadores_en_variable_temporal();
                            this.carga_nombres_de_archivos_DB_comparando();
                        }
                    }
                    for (int k = 0; k < records; ++k) {
                        Skymap sk = new Skymap();
                        String anyo = "";
                        String fnombre = "";
                        GregorianCalendar timeaux = new GregorianCalendar();
                        if (this.filesDB.ficheros != null) {
                            for (i = 0; i < this.filesDB.ficheros.length; ++i) {
                                Pantalla.this.progb.setValue(100 * ++contador_total / (this.filesDB.ficheros.length * records));
                                String rutaynombre = "";
                                rutaynombre = this.filesDB.ruta + this.filesDB.ficheros[i];
                                anyo = "";
                                fnombre = rutaynombre;
                                anyo = fnombre.substring(fnombre.length() - 15, fnombre.length() - 11);
                                Cadena cad = new Cadena(anyo);
                                if (Pantalla.this.yearbox.getText().equals("")) {
                                    if (cad.isIntNumber()) {
                                        fini.set(1, Integer.parseInt(anyo));
                                    } else {
                                        Pantalla.this.ventanalog.log("Problem getting year fromfile name: " + fnombre);
                                    }
                                }
                                if (!(Pantalla.this.cumple_condicion_de_proceso(rutaynombre, fini, periodo) & cad.isIntNumber() & (this.ValidFileInList(this.filesDB.ficheros[i]) & RaMAP.program_status == 1 || RaMAP.program_status == 0))) continue;
                                if (i == 0) {
                                    sk.set_Skymap(Pantalla.this.pasa_datos_de_fichero_DB_a_skm(rutaynombre, fini, periodo));
                                    continue;
                                }
                                sk.unir(Pantalla.this.pasa_datos_de_fichero_DB_a_skm(rutaynombre, fini, periodo), 1);
                            }
                        }
                        timeaux.setTime(fini.getTime());
                        timeaux.add(12, 30);
                        sk.set_hora(timeaux);
                        sk.usado = true;
                        askm.array_de_Skymaps[k].set_Skymap(sk);
                        fini.add(10, incremento);
                    }
                    Pantalla.this.mskmaps = askm;
                    Pantalla.this.registro = periodo >= 0 ? 1 : records;
                    Pantalla.this.last_skymap = records;
                    Pantalla.this.presenta_Skymap_en_grafico();
                    Pantalla.this.progb.setValue(0);
                    Pantalla.this.ventanalog.log("[ProcesaDirectorio_DB] process ends.");
                    Pantalla.this.ventanalog.log("--------------------------------------------------");
                } else {
                    Pantalla.this.ventanalog.log("[ProcesaDirectorio_DB] process not done.");
                    Pantalla.this.ventanalog.log("--------------------------------------------------");
                }
            }
            catch (Exception e) {
                Pantalla.this.ventanalog.log("EXCEPTION: Class: <procesa_directorio_DB>.");
                Pantalla.this.ventanalog.log("Method: <ProcesaDirectorio_DB>");
                Pantalla.this.ventanalog.log_tracktrace(e);
            }
        }

        @Override
        public void run() {
            Pantalla.this.process_button.setEnabled(false);
            this.ProcesaDirectorio_DB();
            if (RaMAP.program_status == 1) {
                RaMAP.pantalla.realtime.temporizador_salva_imagen.start();
            }
            Pantalla.this.process_button.setEnabled(true);
            RaMAP.DB_Files_Process_End = true;
        }

        public void main() {
            new Thread((Runnable)new procesa_directorio_DB(), "Process_DB").start();
        }
    }

    public class RealTime
    implements Runnable {
        Timer temporizador_procesa_archivos_DB = new Timer(90000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealTime.this.procesa_archivos_DB_en_Real_Time();
            }
        });
        public Timer temporizador_salva_imagen = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealTime.this.salva_imagen_en_tiempo_real();
            }
        });

        private void descarga_archivos_RMOB() {
            String filename = "";
            String base = Pantalla.this.rmob_data_source;
            DescargaRMOB df = new DescargaRMOB();
            df.start();
        }

        public void procesa_archivos_RMOB_en_Real_Time() {
            RaMAP.last_realtime_directory_rmob = Pantalla.this.rlt_directory_rmob;
            Procesa_Ficheros_RMOB rltproc = new Procesa_Ficheros_RMOB(false);
            Pantalla.this.ventanalog.log("-----------------------");
            Pantalla.this.ventanalog.log("Processing RMOB files.");
            Pantalla.this.ventanalog.log("Realtime RMOB Directory: " + Pantalla.this.rlt_directory_rmob);
            Pantalla.this.ventanalog.log("Reading RMOB files...");
            rltproc.main(false);
        }

        public void procesa_archivos_DB_en_Real_Time() {
            String aux = Pantalla.this.last_directory_db;
            Pantalla.this.last_directory_db = Pantalla.this.rlt_directory_db;
            RaMAP.last_realtime_directory_db = Pantalla.this.rlt_directory_db;
            Pantalla.this.ventanalog.log("---------------------");
            Pantalla.this.ventanalog.log("Realtime DB Directory: " + Pantalla.this.rlt_directory_db);
            Pantalla.this.ventanalog.log("Reading DB files...");
            Pantalla.this.actualiza();
            Pantalla.this.last_directory_db = aux;
            this.temporizador_procesa_archivos_DB.stop();
        }

        private void salva_imagen_en_tiempo_real() {
            Pantalla.this.registro = Pantalla.this.last_skymap;
            Pantalla.this.repaint();
            String ruta_imagen = "";
            ruta_imagen = Pantalla.this.rlt_directory_current_image + "current_image.gif";
            File file_imagen = new File(ruta_imagen);
            Pantalla.this.ventanalog.log("Realtime Output Image Directory: " + Pantalla.this.rlt_directory_current_image);
            Pantalla.this.ventanalog.log("Current image file name: " + ruta_imagen);
            ruta_imagen = Pantalla.this.rlt_directory_overlay + "overlay.png";
            File file_overlay = new File(ruta_imagen);
            Pantalla.this.ventanalog.log("Realtime Overlay Directory: " + Pantalla.this.rlt_directory_overlay);
            Pantalla.this.ventanalog.log("Overlay image file: " + ruta_imagen);
            try {
                ImageIO.write((RenderedImage)Pantalla.this.JPaneltoImage(Pantalla.this.panel), "gif", file_imagen);
                JPanel p = new JPanel();
                p.setSize(720, 360);
                ImageIO.write((RenderedImage)Pantalla.this.CielotoImage(p), "png", file_overlay);
            }
            catch (Exception e) {
                Pantalla.this.ventanalog.log("EXCEPTION: Class: <Pantalla>");
                Pantalla.this.ventanalog.log("Method: salva_imagen_en_tiempo_real()");
                Pantalla.this.ventanalog.log_tracktrace(e);
                Pantalla.this.ventanalog.log(Pantalla.this.rlt_directory_rmob);
                Pantalla.this.ventanalog.log(Pantalla.this.rlt_directory_db);
                Pantalla.this.ventanalog.log(Pantalla.this.rlt_directory_current_image);
            }
            if (RaMAP.program_status == 1) {
                FicheroSkymap fsk = new FicheroSkymap();
                FechaHora fh = new FechaHora();
                int i = 0;
                while (i < ((Pantalla)Pantalla.this).mskmaps.array_de_Skymaps.length & ((Pantalla)Pantalla.this).mskmaps.array_de_Skymaps[i].usado) {
                    ++i;
                }
                String nombrefec = "No_records";
                if (i > 0) {
                    nombrefec = fh.presenta_junto_AMDHMS(((Pantalla)Pantalla.this).mskmaps.array_de_Skymaps[0].get_hora()) + "_" + fh.presenta_junto_AMDHMS(((Pantalla)Pantalla.this).mskmaps.array_de_Skymaps[i - 1].get_hora());
                }
                fsk.ruta = Pantalla.this.rlt_directory_skm;
                fsk.nombre = "SkyMAP.skm";
                String file_skm = fsk.ruta + fsk.nombre;
                Pantalla.this.ventanalog.log("SKM realtime output file: " + file_skm);
                i = 0;
                try {
                    fsk.asigna_nombre_escritura(file_skm);
                    while (((Pantalla)Pantalla.this).mskmaps.array_de_Skymaps[i].usado) {
                        fsk.escribir_Skymap(((Pantalla)Pantalla.this).mskmaps.array_de_Skymaps[i]);
                        ++i;
                    }
                    fsk.cerrar_fichero();
                }
                catch (Exception e) {
                    Pantalla.this.ventanalog.log("EXCEPTION: Class: <Pantalla>");
                    Pantalla.this.ventanalog.log("Method: salva_imagen_en_tiempo_real");
                    Pantalla.this.ventanalog.log_tracktrace(e);
                }
            }
            this.temporizador_salva_imagen.stop();
        }

        private void procesa_archivos_en_tiempo_real() {
            Pantalla.this.ventanalog.log("-----------------");
            Pantalla.this.ventanalog.log("Real Time Process");
            Pantalla.this.ventanalog.log("-----------------");
            if (Pantalla.this.carga_archivo_de_configuracion() == 0) {
                GregorianCalendar gc = new GregorianCalendar();
                FechaHora fh = new FechaHora();
                Pantalla.this.ventanalog.log("UTC Diff: " + String.valueOf(Pantalla.this.utc_diff));
                int desplaza_hora = Pantalla.this.utc_diff * -1;
                gc.add(10, desplaza_hora);
                String fec = fh.presenta_AMDHMS(gc);
                Pantalla.this.ventanalog.log("Realtime time: " + fec);
                Pantalla.this.yearbox.setText(fec.substring(0, 4));
                Pantalla.this.monthbox.select(fec.substring(5, 7));
                Pantalla.this.daybox.select(fec.substring(8, 10));
                Pantalla.this.hourbox.select(fec.substring(11, 13));
                if (!Pantalla.this.rmob_data_source.isEmpty()) {
                    this.descarga_archivos_RMOB();
                } else {
                    Pantalla.this.ventanalog.log("The rmob_data_source link is empty. No files downloaded.");
                }
            } else {
                Pantalla.this.ventanalog.log("Problem with the paths in the cfg file.");
                Pantalla.this.ventanalog.log("Program path: " + Pantalla.this.ruta_de_la_aplicacion);
                Pantalla.this.ventanalog.log("Real Time process not done.");
            }
        }

        @Override
        public void run() {
            this.procesa_archivos_en_tiempo_real();
        }
    }
}

