/*
 * Decompiled with CFR 0.152.
 */
package rmap.pkg0;

import java.io.Serializable;
import rmap.pkg0.Medidas_de_Dispersion;

public class Celda
implements Serializable {
    static final long serialVersionUID = 100001L;
    public int numero_de_observadores = 0;
    public int conteo_total = 0;
    public float conteo_relativo = 0.0f;
    public float estimacion = 0.0f;
    public float estimacion_relativa = 0.0f;

    public void set_Celda(Celda c) {
        this.numero_de_observadores = c.numero_de_observadores;
        this.conteo_relativo = c.conteo_relativo;
        this.conteo_total = c.conteo_total;
        this.estimacion = c.estimacion;
        this.estimacion_relativa = c.estimacion_relativa;
    }

    int get_numero_de_observadores() {
        return this.numero_de_observadores;
    }

    int get_conteo_total() {
        return this.conteo_total;
    }

    float get_conteo_relativo() {
        return this.conteo_relativo;
    }

    public void promedia(long num_obs, long cont) throws Exception {
        long n = (long)this.get_numero_de_observadores() + num_obs;
        long c = (long)this.get_conteo_total() + cont;
        if (n > 0L) {
            this.estimacion = c / n;
        }
    }

    public void promedia_relativa(long num_obs, float cont_rel) throws Exception {
        long n = (long)this.get_numero_de_observadores() + num_obs;
        float c = this.get_conteo_relativo() + cont_rel;
        if (n > 0L) {
            this.estimacion_relativa = c / ((float)n * 1.0f);
        }
    }

    void estima() throws Exception {
        this.promedia(this.numero_de_observadores, this.conteo_total);
    }

    void estima_relativa() throws Exception {
        this.promedia_relativa(this.numero_de_observadores, this.conteo_relativo);
    }

    float calcula_conteo_relativo(int conteo_total, float media) throws Exception {
        float cr = 0.0f;
        if (media > 0.0f) {
            cr = (float)conteo_total * 50.0f / media;
        }
        return cr;
    }

    void set_datos(int numero_de_observadores, int conteo_total, Medidas_de_Dispersion medidas) throws Exception {
        this.numero_de_observadores = numero_de_observadores;
        this.conteo_total = conteo_total;
        this.estima();
        this.conteo_relativo = this.calcula_conteo_relativo(conteo_total, medidas.media);
        this.promedia_relativa(this.numero_de_observadores, this.conteo_relativo);
    }

    void set_estimacion(float p) {
        this.estimacion = p;
    }

    double get_estimacion() {
        return this.estimacion;
    }

    void set_porcentaje_relativo(float pr) {
        this.estimacion_relativa = pr;
    }

    double get_porcentaje_relativo() {
        return this.estimacion_relativa;
    }

    void suma_a_numero_de_observadores(long s) {
        this.numero_de_observadores = (int)((long)this.numero_de_observadores + s);
    }

    void suma_a_conteo_total(long cont) {
        this.conteo_total = (int)((long)this.conteo_total + cont);
    }

    void suma_a_conteo_relativo(float cont_rel) {
        this.conteo_relativo += cont_rel;
    }

    void suma_datos(long nobs, long cont, float cont_rel) throws Exception {
        this.suma_a_numero_de_observadores(nobs);
        this.suma_a_conteo_total(cont);
        this.suma_a_conteo_relativo(cont_rel);
        this.estima();
        this.estima_relativa();
    }
}

