/*
 * Decompiled with CFR 0.152.
 */
package report;

import cadenas.FechaHora;
import ficheros.FicheroTexto;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;

public class Ventana_de_Log
extends Frame {
    private Button clean_button = new Button();
    private Checkbox loggingchk = new Checkbox();
    private TextArea salida = new TextArea();
    private Button exit_button = new Button();
    private Frame f = new Frame();
    public static int SPANISH = 1;
    public static int ENGLISH = 2;
    private int language = 1;
    public String traza = "";
    private boolean insert_time = true;
    private boolean remove_upper_line = false;
    public FicheroTexto salfic = new FicheroTexto();

    public Ventana_de_Log() {
        this.elementos_de_la_ventana();
        this.pack();
    }

    public Ventana_de_Log(String title) {
        super(title);
        this.elementos_de_la_ventana();
        this.pack();
    }

    public Ventana_de_Log(String title, boolean insert_time) {
        super(title);
        this.insert_time = insert_time;
        this.elementos_de_la_ventana();
        this.pack();
    }

    public Ventana_de_Log(String title, boolean insert_time, boolean remove_upper_line) {
        super(title);
        this.insert_time = insert_time;
        this.remove_upper_line = remove_upper_line;
        this.elementos_de_la_ventana();
        this.pack();
    }

    public void ir_al_principio() {
        this.salida.select(0, 0);
    }

    public void set_language(int l) {
        this.language = l;
        this.select_language();
    }

    private void select_language() {
        switch (this.language) {
            case 1: {
                this.clean_button.setLabel("Limpiar");
                this.loggingchk.setLabel("Depurar");
                this.exit_button.setLabel("Salir");
                break;
            }
            case 2: {
                this.clean_button.setLabel("Clean");
                this.loggingchk.setLabel("Debug");
                this.exit_button.setLabel("Exit");
            }
        }
    }

    public void log_depuracion(String s) {
        if (this.loggingchk.getState()) {
            this.log(s);
        }
    }

    public void log_tracktrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.traza = sw.toString();
        this.log("\n" + this.traza);
    }

    public void elementos_de_la_ventana() {
        this.select_language();
        Container contenedor = new Container();
        contenedor.setSize(840, 400);
        GridBagLayout gbl = new GridBagLayout();
        contenedor.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.5;
        gbc.weightx = 1.0;
        if (!this.remove_upper_line) {
            contenedor.add((Component)this.loggingchk, gbc);
        }
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 0.5;
        gbc.weightx = 100.0;
        if (!this.remove_upper_line) {
            contenedor.add((Component)this.clean_button, gbc);
        }
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weighty = 100.0;
        gbc.weightx = 100.0;
        contenedor.add((Component)this.salida, gbc);
        Font font = new Font("Monospaced", 0, 12);
        this.salida.setFont(font);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 0.5;
        gbc.weightx = 1.0;
        gbc.ipady = 10;
        contenedor.add((Component)this.exit_button, gbc);
        this.setBackground(SystemColor.control);
        this.add(contenedor);
        this.setSize(contenedor.getSize());
    }

    private String prepara_linea(String linea) {
        String aux = "";
        GregorianCalendar c = new GregorianCalendar();
        FechaHora fh = new FechaHora();
        aux = this.insert_time ? fh.presenta_AMDHMSmS(c) + "> " + linea : linea;
        return aux;
    }

    public void log(String linea) {
        String s = this.prepara_linea(linea);
        this.salida.append(s + System.lineSeparator());
        this.salva_linea(s);
    }

    public int salva_log(String rutaynombre) throws Exception {
        FicheroTexto ft = new FicheroTexto();
        if (ft.asigna_nombre_escritura(rutaynombre) == 0) {
            ft.escribir_datos(this.salida.getText());
            ft.cerrar_fichero_salida();
            return 0;
        }
        return 1;
    }

    public int salva_linea(String linea) {
        if (!this.salfic.nombre.isEmpty()) {
            try {
                this.salfic.escribir_linea(linea);
            }
            catch (Exception e) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    public void cls() {
        this.salida.setText("");
    }

    @Override
    public boolean handleEvent(Event evento) {
        Object argumento = evento.arg;
        Object elemento = evento.target;
        String nombre = "";
        switch (evento.id) {
            case 201: {
                this.setVisible(false);
            }
        }
        if (elemento instanceof Button) {
            nombre = (String)argumento;
            if ("Clean".equals(nombre) || "Limpiar".equals(nombre)) {
                this.salida.setText("");
            }
            if ("Exit".equals(nombre) || "Salir".equals(nombre)) {
                this.setVisible(false);
            }
        }
        if (elemento instanceof TextArea) {
            // empty if block
        }
        return true;
    }
}

